/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.control;

import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.control.CommandNotFoundException;
import com.couchbase.mock.control.CommandStatus;
import com.couchbase.mock.control.MockCommand;
import com.couchbase.mock.control.SetSaslMechanismsCommandHandler;
import com.couchbase.mock.control.handlers.CCCPCommandHandler;
import com.couchbase.mock.control.handlers.CheckRetryVerifyCommandHandler;
import com.couchbase.mock.control.handlers.CompressionCommandHandler;
import com.couchbase.mock.control.handlers.EnhancedErrorsCommandHandler;
import com.couchbase.mock.control.handlers.FailoverCommandHandler;
import com.couchbase.mock.control.handlers.GetCmdLogCommandHandler;
import com.couchbase.mock.control.handlers.GetMCPortsHandler;
import com.couchbase.mock.control.handlers.HiccupCommandHandler;
import com.couchbase.mock.control.handlers.KeyInfoCommandHandler;
import com.couchbase.mock.control.handlers.MockHelpCommandHandler;
import com.couchbase.mock.control.handlers.MockInfoCommandHandler;
import com.couchbase.mock.control.handlers.OpfailCommandHandler;
import com.couchbase.mock.control.handlers.PersistenceCommandHandler;
import com.couchbase.mock.control.handlers.RegenCoordsHandler;
import com.couchbase.mock.control.handlers.ResetQueryStateHandler;
import com.couchbase.mock.control.handlers.RespawnCommandHandler;
import com.couchbase.mock.control.handlers.SetQueryErrorStateCommandHandler;
import com.couchbase.mock.control.handlers.StartCmdLogCommandHandler;
import com.couchbase.mock.control.handlers.StartRetryVerifyComandHandler;
import com.couchbase.mock.control.handlers.StopCmdLogCommandHandler;
import com.couchbase.mock.control.handlers.TimeTravelCommandHandler;
import com.couchbase.mock.control.handlers.TruncateCommandHandler;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MockCommandDispatcher {
    public static final Map<String, Class> commandMap = new HashMap<String, Class>();
    private static final Map<MockCommand.Command, Class> classMap = new EnumMap<MockCommand.Command, Class>(MockCommand.Command.class);
    private static final Gson gs = new Gson();
    private final CouchbaseMock mock;

    private static void registerClass(MockCommand.Command cmd, Class cls) {
        if (!MockCommand.class.isAssignableFrom(cls)) {
            throw new RuntimeException("Can process only HarakiriMonitor objects");
        }
        String commandName = cmd.toString().toUpperCase();
        commandMap.put(commandName, cls);
        classMap.put(cmd, cls);
    }

    @NotNull
    public CommandStatus dispatch(String command, JsonObject payload) {
        MockCommand obj;
        MockCommand.Command cmd;
        if (!commandMap.containsKey(command = command.replaceAll(" ", "_").toUpperCase())) {
            throw new CommandNotFoundException("Unknown command: " + command);
        }
        try {
            cmd = MockCommand.Command.valueOf(command.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new CommandNotFoundException("No such command: " + command, e);
        }
        Class cls = classMap.get((Object)cmd);
        if (cls == null) {
            throw new RuntimeException("Can't find class for " + (Object)((Object)cmd));
        }
        try {
            obj = (MockCommand)cls.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        CommandStatus commandStatus = obj.execute(this.mock, cmd, payload);
        if (commandStatus == null) {
            MockCommandDispatcher.$$$reportNull$$$0(0);
        }
        return commandStatus;
    }

    public MockCommandDispatcher(CouchbaseMock mock) {
        this.mock = mock;
    }

    public CouchbaseMock getMock() {
        return this.mock;
    }

    public String processInput(String input) {
        CommandStatus status;
        JsonObject object;
        try {
            object = gs.fromJson(input, JsonObject.class);
        }
        catch (Throwable t) {
            return "{ \"status\" : \"fail\", \"error\" : \"Failed to parse input\" }";
        }
        String command = object.get("command").getAsString();
        JsonObject payload = !object.has("payload") ? new JsonObject() : object.get("payload").getAsJsonObject();
        try {
            status = this.dispatch(command, payload);
        }
        catch (Throwable t) {
            status = new CommandStatus();
            status.fail(t).setPayload(payload);
        }
        return status.toString();
    }

    static {
        MockCommandDispatcher.registerClass(MockCommand.Command.HICCUP, HiccupCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.FAILOVER, FailoverCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.TRUNCATE, TruncateCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.RESPAWN, RespawnCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.MOCKINFO, MockInfoCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.CACHE, PersistenceCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.UNCACHE, PersistenceCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.PERSIST, PersistenceCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.UNPERSIST, PersistenceCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.ENDURE, PersistenceCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.PURGE, PersistenceCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.KEYINFO, KeyInfoCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.TIME_TRAVEL, TimeTravelCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.HELP, MockHelpCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.OPFAIL, OpfailCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.SET_CCCP, CCCPCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.GET_MCPORTS, GetMCPortsHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.REGEN_VBCOORDS, RegenCoordsHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.RESET_QUERYSTATE, ResetQueryStateHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.START_CMDLOG, StartCmdLogCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.STOP_CMDLOG, StopCmdLogCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.GET_CMDLOG, GetCmdLogCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.START_RETRY_VERIFY, StartRetryVerifyComandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.CHECK_RETRY_VERIFY, CheckRetryVerifyCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.SET_ENHANCED_ERRORS, EnhancedErrorsCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.SET_QUERY_ERROR_STATE, SetQueryErrorStateCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.SET_COMPRESSION, CompressionCommandHandler.class);
        MockCommandDispatcher.registerClass(MockCommand.Command.SET_SASL_MECHANISMS, SetSaslMechanismsCommandHandler.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/couchbase/mock/control/MockCommandDispatcher", "dispatch"));
    }
}

