/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.http;

import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.JsonUtils;
import com.couchbase.mock.http.Role;
import com.couchbase.mock.http.User;
import com.couchbase.mock.httpio.HandlerUtil;
import com.couchbase.mock.httpio.HttpServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class UserManagementHandler {
    private final CouchbaseMock mock;
    private final HttpRequestHandler getUsersHandler = new HttpRequestHandler(){

        @Override
        public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
            String method = httpRequest.getRequestLine().getMethod();
            String username = UserManagementHandler.this.getUsername(httpRequest);
            String password = null;
            Boolean userExists = UserManagementHandler.this.mock.getUsers().containsKey(username);
            if (method.equals("GET")) {
                if (username.isEmpty()) {
                    ArrayList<User> localUsers = new ArrayList<User>();
                    localUsers.addAll(UserManagementHandler.this.mock.getUsers().values());
                    HandlerUtil.makeJsonResponse(httpResponse, JsonUtils.encode(localUsers));
                    return;
                }
                if (!userExists.booleanValue()) {
                    httpResponse.setStatusCode(404);
                    return;
                }
                User user = UserManagementHandler.this.mock.getUsers().get(username);
                HandlerUtil.makeJsonResponse(httpResponse, JsonUtils.encode(user));
                return;
            }
            if (method.equals("PUT") && !username.isEmpty() && httpRequest instanceof HttpEntityEnclosingRequest) {
                ArrayList<Role> roles = new ArrayList<Role>();
                User user = userExists != false ? UserManagementHandler.this.mock.getUsers().get(username) : new User("local", username);
                HttpEntity entity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
                List<NameValuePair> content = URLEncodedUtils.parse(entity);
                for (NameValuePair pair : content) {
                    if ("roles".equals(pair.getName())) {
                        String[] rolesList;
                        Pattern pattern = Pattern.compile("(.+)(\\[(.+)])");
                        String rolesEncoded = pair.getValue();
                        for (String role : rolesList = rolesEncoded.split(",")) {
                            Matcher matcher = pattern.matcher(role);
                            if (!matcher.find()) continue;
                            roles.add(new Role(matcher.group(1), matcher.group(3)));
                        }
                        continue;
                    }
                    if ("password".equals(pair.getName())) {
                        password = pair.getValue();
                        continue;
                    }
                    if (!"name".equals(pair.getName())) continue;
                    user.setName(pair.getValue());
                }
                if (roles.size() == 0) {
                    httpResponse.setStatusCode(400);
                    return;
                }
                user.setRoles(roles);
                if (!userExists.booleanValue() && (password == null || password.isEmpty())) {
                    httpResponse.setStatusCode(400);
                    return;
                }
                UserManagementHandler.this.mock.getUsers().put(username, user);
                return;
            }
            if (method.equals("DELETE") && !username.isEmpty() && userExists.booleanValue()) {
                UserManagementHandler.this.mock.getUsers().remove(username);
                return;
            }
            httpResponse.setStatusCode(400);
        }
    };

    public UserManagementHandler(CouchbaseMock mock) {
        this.mock = mock;
    }

    public void register(HttpServer server) {
        server.register("/settings/rbac/users/local*", this.getUsersHandler);
    }

    private String getUsername(HttpRequest httpRequest) {
        String username = "";
        String[] parts = httpRequest.getRequestLine().getUri().split("local/");
        if (parts.length == 2) {
            username = parts[1];
        }
        return username;
    }
}

