/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.VBucketStore;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryGetCommand;
import com.couchbase.mock.memcached.protocol.BinaryGetResponse;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.CommandCode;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.net.ProtocolException;
import java.security.AccessControlException;

public class GetCommandExecutor
implements CommandExecutor {
    @Override
    public BinaryResponse execute(BinaryCommand command, MemcachedServer server, MemcachedConnection client) throws ProtocolException {
        ErrorCode ec;
        Item item;
        VBucketStore cache;
        BinaryGetCommand cmd = (BinaryGetCommand)command;
        CommandCode cc = cmd.getComCode();
        if (cc == CommandCode.GET_REPLICA) {
            cache = server.getStorage().getCache(cmd.getVBucketId());
            if (!server.getStorage().getVBucketInfo(cmd.getVBucketId()).hasAccess(server)) {
                throw new AccessControlException("we're not a master or replica");
            }
        } else {
            cache = server.getStorage().getCache(server, cmd.getVBucketId());
        }
        if ((item = cache.get(cmd.getKeySpec())) == null) {
            if (cc != CommandCode.GETKQ && cc != CommandCode.GETQ && cc != CommandCode.GATQ) {
                return new BinaryGetResponse((BinaryCommand)cmd, ErrorCode.KEY_ENOENT, server.isEnhancedErrorsEnabled() ? "Failed to lookup item" : null);
            }
            throw new ProtocolException("invalid opcode for Get handler: " + (Object)((Object)cmd.getComCode()));
        }
        if (cc == CommandCode.GETL) {
            ErrorCode ec2 = cache.lock(item, cmd.getExpiration());
            if (ec2 != ErrorCode.SUCCESS) {
                return new BinaryResponse(cmd, ec2, server.isEnhancedErrorsEnabled() ? "Failed to lock item" : null);
            }
            return new BinaryGetResponse(cmd, item, item.getCasReal(), client.snappyMode());
        }
        if ((cc == CommandCode.TOUCH || cc == CommandCode.GAT || cc == CommandCode.GATQ) && (ec = cache.touch(item, cmd.getExpiration(), client.supportsXerror())) != ErrorCode.SUCCESS) {
            return new BinaryResponse(cmd, ec);
        }
        if (cc == CommandCode.TOUCH) {
            return new BinaryGetResponse(cmd, ErrorCode.SUCCESS);
        }
        return new BinaryGetResponse((BinaryCommand)cmd, item, client.snappyMode());
    }
}

