/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import java.io.IOException;
import java.net.ProtocolException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public final class SaslCallbackHandler
implements CallbackHandler {
    private final String username;
    private final String password;

    public SaslCallbackHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                continue;
            }
            throw new ProtocolException("SASLServer requested unsupported callback: " + callback);
        }
    }
}

