/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.SaslCallbackHandler;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.BinarySaslResponse;
import com.couchbase.mock.memcached.protocol.CommandCode;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import com.couchbase.mock.security.sasl.Sasl;
import java.net.ProtocolException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

public class SaslCommandExecutor
implements CommandExecutor {
    private SaslServer saslServer;

    @Override
    public BinaryResponse execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) throws ProtocolException {
        BinaryResponse response;
        CommandCode cc = cmd.getComCode();
        String mechanism = cmd.getKey();
        switch (cc) {
            case SASL_LIST_MECHS: {
                StringBuilder sb = new StringBuilder();
                for (String m : server.getSaslMechanisms()) {
                    sb.append(m + " ");
                }
                response = new BinarySaslResponse(cmd, sb.toString());
                break;
            }
            case SASL_AUTH: {
                if (server.supportsSaslMechanism(mechanism)) {
                    if ("PLAIN".equals(mechanism)) {
                        response = this.plainAuth(cmd, server, client);
                        break;
                    }
                    this.createSaslServer(cmd, server);
                    response = this.saslAuth(cmd, client);
                    break;
                }
                response = new BinarySaslResponse(cmd);
                break;
            }
            case SASL_STEP: {
                response = this.saslAuth(cmd, client);
                break;
            }
            default: {
                response = new BinarySaslResponse(cmd);
            }
        }
        return response;
    }

    private BinarySaslResponse plainAuth(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        BinarySaslResponse response;
        byte[] raw = cmd.getValue();
        String[] strs = new String[3];
        int offset = 0;
        int oix = 0;
        for (int ii = 0; ii < raw.length; ++ii) {
            if (raw[ii] != 0) continue;
            strs[oix++] = new String(raw, offset, ii - offset);
            offset = ii + 1;
        }
        strs[oix] = new String(raw, offset, raw.length - offset);
        String user = strs[1];
        String pass = strs[2];
        Bucket bucket = server.getBucket();
        String bPass = bucket.getPassword();
        if (!bucket.getName().equals(user) || !bPass.equals(pass)) {
            response = new BinarySaslResponse(cmd);
        } else {
            client.setAuthenticated();
            response = new BinarySaslResponse(cmd, "Authenticated");
        }
        return response;
    }

    private void createSaslServer(BinaryCommand cmd, MemcachedServer server) throws ProtocolException {
        try {
            Bucket bucket = server.getBucket();
            this.saslServer = Sasl.createSaslServer(cmd.getKey(), server.getHostname(), null, new SaslCallbackHandler(bucket.getName(), bucket.getPassword()));
        }
        catch (SaslException e) {
            throw new ProtocolException(e.getMessage());
        }
    }

    private BinaryResponse saslAuth(BinaryCommand cmd, MemcachedConnection client) throws ProtocolException {
        if (this.saslServer == null) {
            return new BinarySaslResponse(cmd);
        }
        byte[] raw = cmd.getValue();
        try {
            BinarySaslResponse response;
            byte[] challenge = this.saslServer.evaluateResponse(raw);
            if (this.saslServer.isComplete()) {
                client.setAuthenticated();
                response = new BinarySaslResponse(cmd, new String(challenge));
            } else {
                response = new BinarySaslResponse(cmd, new String(challenge), ErrorCode.AUTH_CONTINUE);
            }
            return response;
        }
        catch (SaslException e) {
            throw new ProtocolException(e.getMessage());
        }
    }
}

