/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

import com.couchbase.mock.memcached.KeySpec;
import com.couchbase.mock.memcached.protocol.CommandCode;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.util.UUID;

public class BinaryCommand {
    private final CommandCode cc;
    protected final short keyLength;
    protected final byte extraLength;
    protected final byte opcode;
    protected final byte datatype;
    private final short vbucket;
    protected final int bodyLength;
    private final int opaque;
    final long cas;
    final ByteBuffer bodyBuffer;
    private String eventId;

    BinaryCommand(ByteBuffer header) throws ProtocolException {
        header.rewind();
        header.get();
        this.opcode = header.get();
        this.cc = CommandCode.valueOf(this.opcode);
        this.keyLength = header.getShort();
        this.extraLength = header.get();
        this.datatype = header.get();
        this.vbucket = header.getShort();
        this.bodyLength = header.getInt();
        this.opaque = header.getInt();
        this.cas = header.getLong();
        this.bodyBuffer = this.bodyLength > 0 ? ByteBuffer.allocate(this.bodyLength) : null;
    }

    public ByteBuffer getInputBuffer() {
        return this.bodyBuffer;
    }

    public CommandCode getComCode() {
        return this.cc;
    }

    public byte getOpcode() {
        return this.opcode;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public short getVBucketId() {
        return this.vbucket;
    }

    public long getCas() {
        return this.cas;
    }

    public String getKey() {
        if (this.keyLength == 0) {
            return null;
        }
        return new String(this.bodyBuffer.array(), (int)this.extraLength, (int)this.keyLength);
    }

    public KeySpec getKeySpec() {
        return new KeySpec(this.getKey(), this.vbucket);
    }

    public byte[] getValue() {
        byte[] ret = new byte[this.bodyLength - this.extraLength - this.keyLength];
        System.arraycopy(this.bodyBuffer.array(), this.extraLength + this.keyLength, ret, 0, ret.length);
        return ret;
    }

    public String getEventId() {
        return this.eventId;
    }

    public boolean complete() {
        return this.bodyLength == 0 || !this.bodyBuffer.hasRemaining();
    }

    public void process() throws ProtocolException {
    }

    public void generateEventId() {
        this.eventId = UUID.randomUUID().toString();
    }
}

