/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.subdoc.Operation;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class BinarySubdocMultiCommand
extends BinaryCommand {
    private int expiryTime;
    private boolean hasExpiry;
    private byte docFlags;
    protected final List<MultiSpec> specs = new ArrayList<MultiSpec>();

    public BinarySubdocMultiCommand(ByteBuffer header) throws ProtocolException {
        super(header);
    }

    @Override
    public void process() throws ProtocolException {
        this.bodyBuffer.rewind();
        switch (this.extraLength) {
            case 0: {
                this.expiryTime = 0;
                this.docFlags = 0;
                this.hasExpiry = false;
                break;
            }
            case 1: {
                this.expiryTime = 0;
                this.hasExpiry = false;
                this.docFlags = this.bodyBuffer.get(0);
                break;
            }
            case 4: {
                this.expiryTime = this.bodyBuffer.getInt(0);
                this.hasExpiry = true;
                this.docFlags = 0;
                break;
            }
            case 5: {
                this.expiryTime = this.bodyBuffer.getInt(0);
                this.hasExpiry = true;
                this.docFlags = this.bodyBuffer.get(4);
                break;
            }
            default: {
                throw new ProtocolException("Extras must be 0, 1, 4, or 5!");
            }
        }
        try {
            this.bodyBuffer.position(this.extraLength + this.keyLength);
            this.extractSpecs();
        }
        finally {
            this.bodyBuffer.rewind();
        }
        if (this.specs.isEmpty()) {
            throw new ProtocolException("Found no specs!");
        }
    }

    protected abstract void extractSpecs() throws ProtocolException;

    public List<MultiSpec> getLookupSpecs() {
        return this.specs;
    }

    public int getNewExpiry(int oldExpiry) {
        if (this.hasExpiry) {
            return this.expiryTime;
        }
        return oldExpiry;
    }

    public byte getSubdocDocFlags() {
        return this.docFlags;
    }

    public static class MultiSpec {
        private final Operation op;
        private final String path;
        private final String value;
        private final byte flags;

        protected MultiSpec(Operation op, String path, String value, byte flags) {
            this.op = op;
            this.path = path;
            this.flags = flags;
            this.value = value;
        }

        protected MultiSpec(Operation op, String path, byte flags) {
            this(op, path, null, flags);
        }

        public Operation getOp() {
            return this.op;
        }

        public String getPath() {
            return this.path;
        }

        public String getValue() {
            return this.value;
        }

        public byte getFlags() {
            return this.flags;
        }
    }
}

