/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.security.sasl;

import com.couchbase.mock.security.sasl.ShaSaslServer;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public class ShaSaslServerFactory
implements SaslServerFactory {
    private static final String SCRAM_SHA512 = "SCRAM-SHA512";
    private static final String SCRAM_SHA256 = "SCRAM-SHA256";
    private static final String SCRAM_SHA1 = "SCRAM-SHA1";
    public static final String[] SUPPORTED_MECHS = new String[]{"SCRAM-SHA1", "SCRAM-SHA256", "SCRAM-SHA512"};

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        int sha = this.getDigestSize(mechanism);
        if (sha == 0) {
            throw new SaslException("This SCRAM-SHA mechanism is not supported " + mechanism);
        }
        if (cbh == null) {
            throw new SaslException("Callback handler to get username/password required");
        }
        try {
            return new ShaSaslServer(cbh, sha);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException(e.getMessage(), e);
        }
    }

    private int getDigestSize(String mechanism) {
        int sha = 0;
        if (mechanism.equals(SCRAM_SHA512)) {
            sha = 512;
        } else if (mechanism.equals(SCRAM_SHA256)) {
            sha = 256;
        } else if (mechanism.equals(SCRAM_SHA1)) {
            sha = 1;
        }
        return sha;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return SUPPORTED_MECHS;
    }
}

