/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.subdoc;

import com.couchbase.mock.subdoc.BadNumberException;
import com.couchbase.mock.subdoc.CannotInsertException;
import com.couchbase.mock.subdoc.Component;
import com.couchbase.mock.subdoc.DeltaTooBigException;
import com.couchbase.mock.subdoc.DocNotJsonException;
import com.couchbase.mock.subdoc.EmptyValueException;
import com.couchbase.mock.subdoc.InvalidPathException;
import com.couchbase.mock.subdoc.Match;
import com.couchbase.mock.subdoc.NumberTooBigException;
import com.couchbase.mock.subdoc.Operation;
import com.couchbase.mock.subdoc.Path;
import com.couchbase.mock.subdoc.PathExistsException;
import com.couchbase.mock.subdoc.PathMismatchException;
import com.couchbase.mock.subdoc.PathNotFoundException;
import com.couchbase.mock.subdoc.Result;
import com.couchbase.mock.subdoc.SubdocException;
import com.couchbase.mock.subdoc.ZeroDeltaException;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public class Executor {
    public static final Gson gs = new Gson();
    private final Path path;
    private final Operation code;
    private final JsonElement value;
    private final boolean isCreate;
    private final boolean isMultiValue;
    private final Match match;

    private static <T> T parseStrictJson(String text, Class<T> klass) {
        try {
            JSONValue.parseWithException(text);
        }
        catch (ParseException ex) {
            throw new JsonSyntaxException(ex);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        JsonReader reader = new JsonReader(new StringReader(text));
        reader.setLenient(false);
        return gs.fromJson(reader, klass);
    }

    private Executor(String input, Path path, Operation code, String valueFragment, boolean shouldCreateParents) throws SubdocException {
        JsonElement root;
        this.path = path;
        this.code = code;
        this.isCreate = shouldCreateParents;
        if (code.requiresValue()) {
            if (valueFragment == null || valueFragment.isEmpty()) {
                throw new EmptyValueException();
            }
            try {
                if (code.isArrayParent()) {
                    valueFragment = "[" + valueFragment + "]";
                    JsonArray arr = Executor.parseStrictJson(valueFragment, JsonArray.class);
                    if (arr.size() > 1) {
                        this.value = arr;
                        this.isMultiValue = true;
                    }
                    this.value = arr.get(0);
                    this.isMultiValue = false;
                }
                valueFragment = "{\"K\":" + valueFragment + "}";
                JsonObject obj = Executor.parseStrictJson(valueFragment, JsonObject.class);
                if (obj.getAsJsonObject().entrySet().size() != 1) {
                    throw new CannotInsertException("More than one value found in object!");
                }
                this.value = obj.get("K");
                this.isMultiValue = false;
            }
            catch (JsonSyntaxException ex) {
                if (code == Operation.COUNTER) {
                    throw new BadNumberException(ex);
                }
                throw new CannotInsertException(ex);
            }
        } else {
            this.value = null;
            this.isMultiValue = false;
        }
        if (this.isMultiValue && !code.allowsMultiValue()) {
            throw new CannotInsertException("Multi value not allowed!");
        }
        try {
            root = Executor.parseStrictJson(input, JsonElement.class);
        }
        catch (JsonSyntaxException e) {
            throw new DocNotJsonException(e);
        }
        this.match = new Match(root, path);
    }

    public static JsonElement executeGet(String input, String path) throws SubdocException {
        return Executor.execute(input, path, Operation.GET).getMatch();
    }

    public static Result execute(String input, String path, Operation code) throws SubdocException {
        return Executor.execute(input, new Path(path), code);
    }

    public static Result execute(String input, String path, Operation code, String valueFragment, boolean isMkdirP) throws SubdocException {
        return Executor.execute(input, new Path(path), code, valueFragment, isMkdirP);
    }

    public static Result execute(String input, String path, Operation code, String valueFragment) throws SubdocException {
        return Executor.execute(input, path, code, valueFragment, false);
    }

    public static Result execute(String input, Path path, Operation code) throws SubdocException {
        return Executor.execute(input, path, code, null, false);
    }

    public static Result execute(String input, Path path, Operation code, String valueFragment, boolean isMkdirP) throws SubdocException {
        Executor p = new Executor(input, path, code, valueFragment, isMkdirP);
        p.match.execute();
        return p.operate();
    }

    private void insertInJsonArray(JsonArray array, int index) {
        ArrayList<JsonElement> elements = new ArrayList<JsonElement>();
        while (array.size() > 0) {
            elements.add(array.remove(0));
        }
        ArrayList<JsonElement> newElements = new ArrayList<JsonElement>();
        if (this.isMultiValue) {
            for (JsonElement elem : this.value.getAsJsonArray()) {
                newElements.add(elem);
            }
        } else {
            newElements.add(this.value);
        }
        elements.addAll(index, newElements);
        for (JsonElement elem : elements) {
            array.add(elem);
        }
    }

    private void createParents(ParentType parentType, JsonElement newValue) throws SubdocException {
        if (this.match.getDeepest().isJsonArray()) {
            throw new PathMismatchException("Cannot create intermediate array!");
        }
        List<JsonElement> chain = this.match.getChain();
        int lastIndex = chain.size() - 2;
        for (int i = lastIndex + 1; i < this.path.size() - 1; ++i) {
            Component comp = this.path.get(i);
            if (comp.isIndex()) {
                throw new PathNotFoundException();
            }
            JsonObject nextParent = new JsonObject();
            JsonObject prevParent = chain.get(chain.size() - 1).getAsJsonObject();
            chain.add(nextParent);
            prevParent.add(comp.getString(), nextParent);
        }
        Component lastComp = this.path.getLast();
        if (lastComp.isIndex()) {
            throw new PathNotFoundException();
        }
        JsonObject deepest = chain.get(chain.size() - 1).getAsJsonObject();
        if (parentType == ParentType.ARRAY) {
            JsonArray parentArray = new JsonArray();
            parentArray.add(newValue);
            deepest.add(lastComp.getString(), parentArray);
        } else {
            deepest.add(lastComp.getString(), newValue);
        }
    }

    private void replace(JsonElement newValue) throws SubdocException {
        if (!this.match.isFound()) {
            throw new PathNotFoundException();
        }
        if (this.path.size() == 0) {
            throw new CannotInsertException("Cannot replace root element!");
        }
        JsonElement parent = this.match.getMatchParent();
        Component comp = this.path.getLast();
        if (comp.isIndex()) {
            int index = comp.getIndex();
            JsonArray array = parent.getAsJsonArray();
            if (index == -1) {
                index = parent.getAsJsonArray().size() - 1;
            }
            array.set(index, this.value);
        } else {
            parent.getAsJsonObject().add(comp.getString(), newValue);
        }
    }

    private JsonElement dictAdd(JsonElement newValue) throws SubdocException {
        if (this.match.isFound()) {
            throw new PathExistsException();
        }
        if (!this.match.hasImmediateParent()) {
            if (!this.isCreate) {
                throw new PathNotFoundException();
            }
            this.createParents(ParentType.OBJECT, newValue);
            return this.match.getRoot();
        }
        Component lastComp = this.path.getLast();
        JsonElement parent = this.match.getImmediateParent();
        if (!parent.isJsonObject()) {
            throw new PathMismatchException("DICT_ADD must have dictionary parent");
        }
        parent.getAsJsonObject().add(lastComp.getString(), newValue);
        return this.match.getRoot();
    }

    private void ensureUnique(JsonArray array) throws SubdocException {
        if (!this.value.isJsonPrimitive() && !this.value.isJsonNull()) {
            throw new CannotInsertException("Cannot verify uniqueness with non-primitives");
        }
        String valueString = this.value.toString();
        for (int i = 0; i < array.size(); ++i) {
            JsonElement e = array.get(i);
            if (!e.isJsonPrimitive()) {
                throw new PathMismatchException("Values in the array are not all primitives");
            }
            if (!e.toString().equals(valueString)) continue;
            throw new PathExistsException();
        }
    }

    private void arrayAdd() throws SubdocException {
        if (!this.match.isFound()) {
            if (this.isCreate) {
                this.createParents(ParentType.ARRAY, this.value);
                return;
            }
            throw new PathNotFoundException();
        }
        JsonElement lastElem = this.match.getDeepest();
        if (!lastElem.isJsonArray()) {
            throw new PathMismatchException();
        }
        JsonArray array = lastElem.getAsJsonArray();
        if (this.code == Operation.ADD_UNIQUE) {
            this.ensureUnique(array);
        }
        this.insertInJsonArray(array, this.code == Operation.ARRAY_APPEND ? array.size() : 0);
    }

    private void arrayInsert() throws SubdocException {
        int position = this.path.getLast().getIndex();
        if (!this.match.hasImmediateParent()) {
            throw new PathNotFoundException();
        }
        JsonArray array = this.match.getImmediateParent().getAsJsonArray();
        if (position == -1) {
            throw new InvalidPathException("Insert does not accept negative arrays");
        }
        if (position > array.size()) {
            throw new PathNotFoundException();
        }
        this.insertInJsonArray(array, position);
    }

    private Result remove() throws SubdocException {
        JsonElement removedElement;
        if (!this.match.isFound()) {
            throw new PathNotFoundException();
        }
        if (this.path.size() == 0) {
            throw new CannotInsertException("Cannot delete root element!");
        }
        JsonElement parent = this.match.getImmediateParent();
        Component lastComp = this.path.getLast();
        if (parent.isJsonObject()) {
            removedElement = parent.getAsJsonObject().remove(lastComp.getString());
        } else {
            JsonArray array = parent.getAsJsonArray();
            int index = lastComp.getIndex();
            if (index == -1) {
                index = array.size() - 1;
            }
            removedElement = array.remove(index);
        }
        return new Result(removedElement, this.match.getRoot());
    }

    private static boolean bigintIsWithinRange(BigInteger ee) {
        BigInteger longMax = new BigInteger(Long.toString(Long.MAX_VALUE));
        return ee.compareTo(longMax) <= 0;
    }

    private static JsonElement getCount(JsonElement elem) throws SubdocException {
        if (elem.isJsonObject()) {
            return new JsonPrimitive(elem.getAsJsonObject().entrySet().size());
        }
        if (elem.isJsonArray()) {
            return new JsonPrimitive(elem.getAsJsonArray().size());
        }
        throw new PathMismatchException("GET_COUNT must point to array or dictionary");
    }

    private JsonElement counter() throws SubdocException {
        Long delta;
        try {
            BigInteger ee = this.value.getAsBigInteger();
            if (!Executor.bigintIsWithinRange(ee)) {
                throw new DeltaTooBigException();
            }
            delta = ee.longValue();
        }
        catch (NumberFormatException ex) {
            throw new BadNumberException(ex);
        }
        catch (UnsupportedOperationException ex2) {
            throw new BadNumberException(ex2);
        }
        if (delta == 0L) {
            throw new ZeroDeltaException();
        }
        if (this.match.isFound()) {
            Long numres;
            try {
                BigInteger tmpCombo = this.match.getMatch().getAsBigInteger();
                if (!Executor.bigintIsWithinRange(tmpCombo)) {
                    throw new NumberTooBigException();
                }
                numres = tmpCombo.longValue();
            }
            catch (UnsupportedOperationException ex) {
                throw new PathMismatchException(ex);
            }
            catch (NumberFormatException ex2) {
                throw new PathMismatchException(ex2);
            }
            if (delta >= 0L && numres >= 0L ? Long.MAX_VALUE - delta < numres : delta < 0L && numres < 0L && delta < Long.MIN_VALUE - numres) {
                throw new DeltaTooBigException();
            }
            JsonPrimitive p = new JsonPrimitive(numres + delta);
            this.replace(p);
            return p;
        }
        JsonPrimitive newNum = new JsonPrimitive(delta);
        if (this.match.hasImmediateParent() && this.match.getImmediateParent().isJsonObject()) {
            this.dictAdd(newNum);
        } else if (this.isCreate && this.match.getDeepest().isJsonObject()) {
            this.createParents(ParentType.OBJECT, newNum);
        } else {
            throw new PathNotFoundException();
        }
        return newNum;
    }

    private Result operate() throws SubdocException {
        switch (this.code) {
            case GET: 
            case EXISTS: 
            case GET_COUNT: {
                if (!this.match.isFound()) {
                    throw new PathNotFoundException();
                }
                if (this.code == Operation.GET_COUNT) {
                    return new Result(Executor.getCount(this.match.getMatch()), null);
                }
                return new Result(this.match.getMatch(), null);
            }
            case GET_FULLDOC: {
                return new Result(this.match.getRoot(), null);
            }
            case REPLACE: {
                this.replace(this.value);
                return new Result(null, this.match.getRoot());
            }
            case DICT_UPSERT: {
                if (this.path.getLast().isIndex()) {
                    throw new InvalidPathException("DICT_UPSERT cannot have an array index as its last component");
                }
                if (this.match.isFound()) {
                    this.replace(this.value);
                } else {
                    this.dictAdd(this.value);
                }
                return new Result(null, this.match.getRoot());
            }
            case DICT_ADD: {
                this.dictAdd(this.value);
                return new Result(null, this.match.getRoot());
            }
            case ARRAY_PREPEND: 
            case ARRAY_APPEND: 
            case ADD_UNIQUE: {
                this.arrayAdd();
                return new Result(null, this.match.getRoot());
            }
            case ARRAY_INSERT: {
                this.arrayInsert();
                return new Result(null, this.match.getRoot());
            }
            case REMOVE: {
                return this.remove();
            }
            case COUNTER: {
                return new Result(this.counter(), this.match.getRoot());
            }
            case WRITE_FULLDOC: {
                return new Result(null, this.value);
            }
        }
        throw new RuntimeException("Unknown operation!");
    }

    public static String getRootType(String path, Operation op) {
        if (path.isEmpty()) {
            switch (op) {
                case ARRAY_PREPEND: 
                case ARRAY_APPEND: 
                case ADD_UNIQUE: {
                    return "[]";
                }
                default: {
                    return null;
                }
                case WRITE_FULLDOC: 
            }
            return "{}";
        }
        if (path.charAt(0) == '[') {
            return "[]";
        }
        return "{}";
    }

    static enum ParentType {
        ARRAY,
        OBJECT;

    }
}

