/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.subdoc;

import com.couchbase.mock.subdoc.Component;
import com.couchbase.mock.subdoc.DocNotJsonException;
import com.couchbase.mock.subdoc.Path;
import com.couchbase.mock.subdoc.SubdocException;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;

public class Match {
    private static final Gson gs = new Gson();
    private List<JsonElement> chain = new ArrayList<JsonElement>();
    private final JsonElement root;
    private final Path path;

    public Match(JsonElement root, Path path) {
        this.root = root;
        this.path = path;
        this.chain.add(root);
    }

    public static Match match(String json, String path) throws SubdocException {
        JsonElement e;
        try {
            e = gs.fromJson(json, JsonElement.class);
        }
        catch (JsonSyntaxException ex) {
            throw new DocNotJsonException(ex);
        }
        return Match.match(e, new Path(path));
    }

    public static Match match(JsonElement root, Path path) throws SubdocException {
        Match m = new Match(root, path);
        m.execute();
        return m;
    }

    public void execute() throws SubdocException {
        JsonElement parent = this.root;
        for (int i = 0; i < this.path.size(); ++i) {
            this.path.validateComponentType(i, parent);
            Component component = this.path.get(i);
            if (component.isIndex()) {
                int index = component.getIndex();
                JsonArray array = parent.getAsJsonArray();
                if (array.size() == 0) break;
                if (index == -1) {
                    index = array.size() - 1;
                } else if (index > array.size() - 1) break;
                parent = array.get(index);
            } else {
                JsonObject object = parent.getAsJsonObject();
                parent = object.get(component.getString());
            }
            if (parent == null) break;
            this.chain.add(parent);
        }
    }

    public boolean isFound() {
        if (this.path.size() == 0) {
            return true;
        }
        return this.chain.size() - 1 == this.path.size();
    }

    public boolean hasImmediateParent() {
        if (this.path.size() == 0) {
            return true;
        }
        return this.chain.size() - 1 >= this.path.size() - 1;
    }

    public JsonElement getRoot() {
        return this.root;
    }

    List<JsonElement> getChain() {
        return this.chain;
    }

    JsonElement getDeepest() {
        return this.chain.get(this.chain.size() - 1);
    }

    JsonElement getMatchParent() {
        if (!this.isFound()) {
            throw new IllegalStateException("No match found. Cannot get parent");
        }
        return this.chain.get(this.chain.size() - 2);
    }

    JsonElement getImmediateParent() {
        if (this.isFound()) {
            return this.getMatchParent();
        }
        if (this.hasImmediateParent()) {
            return this.getDeepest();
        }
        throw new IllegalStateException("No match or immediate parent!");
    }

    JsonElement getMatch() {
        if (!this.isFound()) {
            throw new IllegalStateException("No match found!");
        }
        return this.getDeepest();
    }
}

