/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.subdoc;

public enum Operation {
    GET(197),
    EXISTS(198),
    GET_COUNT(210),
    DICT_ADD(199),
    DICT_UPSERT(200),
    REMOVE(201),
    REPLACE(202),
    ARRAY_PREPEND(203),
    ARRAY_APPEND(204),
    ARRAY_INSERT(205),
    ADD_UNIQUE(206),
    COUNTER(205),
    INVALID(255),
    WRITE_FULLDOC(225),
    GET_FULLDOC(226);

    private final int value;

    private Operation(int value) {
        this.value = value;
    }

    public int code() {
        return this.value;
    }

    public boolean requiresValue() {
        switch (this) {
            case GET: 
            case EXISTS: 
            case REMOVE: 
            case GET_COUNT: 
            case GET_FULLDOC: {
                return false;
            }
        }
        return true;
    }

    public boolean allowsMultiValue() {
        switch (this) {
            case ARRAY_APPEND: 
            case ARRAY_PREPEND: 
            case ARRAY_INSERT: {
                return true;
            }
        }
        return false;
    }

    public boolean isMutator() {
        switch (this) {
            case GET: 
            case EXISTS: 
            case GET_COUNT: 
            case GET_FULLDOC: {
                return false;
            }
        }
        return true;
    }

    public boolean isLookup() {
        return !this.isMutator();
    }

    public boolean returnsMatch() {
        switch (this) {
            case GET: 
            case GET_COUNT: 
            case GET_FULLDOC: 
            case COUNTER: {
                return true;
            }
        }
        return false;
    }

    public boolean isArrayParent() {
        switch (this) {
            case ARRAY_APPEND: 
            case ARRAY_PREPEND: 
            case ARRAY_INSERT: 
            case ADD_UNIQUE: {
                return true;
            }
        }
        return false;
    }

    public boolean isCreative() {
        if (!this.isMutator()) {
            return false;
        }
        switch (this) {
            case REMOVE: 
            case REPLACE: {
                return false;
            }
        }
        return true;
    }
}

