/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.http;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.BucketAlreadyExistsException;
import com.couchbase.mock.BucketConfiguration;
import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.DocumentLoader;
import com.couchbase.mock.JsonUtils;
import com.couchbase.mock.deps.com.google.gson.JsonElement;
import com.couchbase.mock.deps.org.apache.http.HttpEntityEnclosingRequest;
import com.couchbase.mock.deps.org.apache.http.HttpException;
import com.couchbase.mock.deps.org.apache.http.HttpRequest;
import com.couchbase.mock.deps.org.apache.http.HttpResponse;
import com.couchbase.mock.deps.org.apache.http.protocol.HttpContext;
import com.couchbase.mock.deps.org.apache.http.protocol.HttpRequestHandler;
import com.couchbase.mock.deps.org.apache.http.util.EntityUtils;
import com.couchbase.mock.http.AuthContext;
import com.couchbase.mock.http.Authenticator;
import com.couchbase.mock.http.StateGrabber;
import com.couchbase.mock.httpio.HandlerUtil;
import com.couchbase.mock.httpio.HttpServer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class PoolsHandler {
    private final CouchbaseMock mock;
    private final HttpRequestHandler poolHandler = new HttpRequestHandler(){

        @Override
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String payload = StateGrabber.getAllPoolsJSON(PoolsHandler.this.mock);
            HandlerUtil.makeJsonResponse(response, payload);
        }
    };
    private final HttpRequestHandler poolsDefaultHandler = new HttpRequestHandler(){

        @Override
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String payload = StateGrabber.getPoolInfoJSON(PoolsHandler.this.mock);
            HandlerUtil.makeJsonResponse(response, payload);
        }
    };
    private final HttpRequestHandler sampleBucketsHandler = new HttpRequestHandler(){

        @Override
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            AuthContext authContext = HandlerUtil.getAuth(context, request);
            if (!PoolsHandler.this.mock.getAuthenticator().isAdministrator(authContext)) {
                response.setStatusCode(401);
                return;
            }
            if (!request.getRequestLine().getMethod().equals("POST")) {
                HandlerUtil.makeResponse(response, "Not Found", 404);
                return;
            }
            if (!(request instanceof HttpEntityEnclosingRequest)) {
                HandlerUtil.make400Response(response, "Must have body");
                return;
            }
            String rawBody = EntityUtils.toString(((HttpEntityEnclosingRequest)request).getEntity());
            JsonElement elem = JsonUtils.GSON.fromJson(rawBody, JsonElement.class);
            if (!elem.isJsonArray()) {
                HandlerUtil.make400Response(response, "Request must be JSON array");
                return;
            }
            for (JsonElement mem : elem.getAsJsonArray()) {
                if (!mem.isJsonPrimitive()) {
                    HandlerUtil.make400Response(response, "Element must be string");
                    return;
                }
                String s = mem.getAsString();
                if (!s.equals("beer-sample")) {
                    HandlerUtil.make400Response(response, String.format("[\"Sample %s is not a valid sample.\"]", s));
                    return;
                }
                try {
                    BucketConfiguration newConfig = new BucketConfiguration(PoolsHandler.this.mock.getDefaultConfig());
                    newConfig.name = "beer-sample";
                    try {
                        PoolsHandler.this.mock.createBucket(newConfig);
                    }
                    catch (BucketAlreadyExistsException ex) {
                        HandlerUtil.make400Response(response, "[\"Sample beer-sample is already loaded.\"]");
                        return;
                    }
                    DocumentLoader.loadBeerSample(PoolsHandler.this.mock);
                }
                catch (IOException ex) {
                    HandlerUtil.makeResponse(response, ex.toString(), 500);
                }
            }
        }
    };
    private final HttpRequestHandler allBucketsHandler = new HttpRequestHandler(){

        private void handleListBuckets(HttpRequest request, HttpResponse response, AuthContext authContext) throws HttpException, IOException {
            ArrayList<Bucket> allowedBuckets = new ArrayList<Bucket>(PoolsHandler.this.mock.getBuckets().size());
            Authenticator authenticator = PoolsHandler.this.mock.getAuthenticator();
            for (Bucket bucket : PoolsHandler.this.mock.getBuckets().values()) {
                if (!authenticator.isAuthorizedForBucket(authContext, bucket)) continue;
                allowedBuckets.add(bucket);
            }
            String payload = StateGrabber.getAllBucketsJSON(allowedBuckets);
            HandlerUtil.makeJsonResponse(response, payload);
        }

        @Override
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String methodName = request.getRequestLine().getMethod();
            AuthContext authContext = HandlerUtil.getAuth(context, request);
            if (methodName.equals("GET")) {
                this.handleListBuckets(request, response, authContext);
            } else if (methodName.equals("POST")) {
                if (!PoolsHandler.this.mock.getAuthenticator().isAdministrator(authContext)) {
                    response.setStatusCode(401);
                } else {
                    try {
                        PoolsHandler.this.handleCreateBucket(request, response, context);
                    }
                    catch (CreateBucketBadParamsException ex) {
                        HandlerUtil.makeResponse(response, ex.getMessage(), 400);
                    }
                }
            }
        }
    };

    public PoolsHandler(CouchbaseMock mock) {
        this.mock = mock;
    }

    public void handleCreateBucket(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException, CreateBucketBadParamsException {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            throw new CreateBucketBadParamsException("Must provide bucket parameters");
        }
        BucketConfiguration config = new BucketConfiguration(this.mock.getDefaultConfig());
        HttpEntityEnclosingRequest entRequest = (HttpEntityEnclosingRequest)request;
        Map<String, String> params = HandlerUtil.getQueryParams(EntityUtils.toString(entRequest.getEntity()));
        String name = params.get("name");
        String authType = params.get("authType");
        if (name == null || name.isEmpty()) {
            throw new CreateBucketBadParamsException("Must provide bucket name");
        }
        config.name = name;
        if (authType == null || authType.isEmpty()) {
            throw new CreateBucketBadParamsException("authType must be specified");
        }
        if (authType.equals("none")) {
            HandlerUtil.makeResponse(response, "Non-SASL auth not supported", 500);
            return;
        }
        if (authType.equals("sasl")) {
            config.password = params.get("saslPassword");
            if (config.password == null) {
                config.password = "";
            }
        } else {
            throw new CreateBucketBadParamsException("authType must be 'sasl' or 'none' (note 'none' is not supported, but is valid)");
        }
        try {
            String sQuota;
            String sReplicas = params.get("replicaNumber");
            if (sReplicas != null) {
                config.numReplicas = Integer.parseInt(sReplicas);
                if (config.numReplicas > config.numNodes - 1) {
                    throw new CreateBucketBadParamsException("Not enough nodes for replicas");
                }
            }
            if ((sQuota = params.get("ramQuotaMB")) == null) {
                throw new CreateBucketBadParamsException("ramQuotaMB missing (but we ignore it)");
            }
            int iQuota = Integer.parseInt(sQuota);
            if (iQuota < 100) {
                throw new CreateBucketBadParamsException("Ram quota must be greater than 100");
            }
        }
        catch (NumberFormatException ex) {
            throw new CreateBucketBadParamsException("Bad numeric value");
        }
        try {
            this.mock.createBucket(config);
            response.setStatusCode(202);
        }
        catch (BucketAlreadyExistsException ex) {
            HandlerUtil.makeResponse(response, ex.getMessage(), 500);
        }
    }

    public void handleDeleteBucket(HttpRequest request, HttpResponse response, HttpContext context, Bucket bucket) throws HttpException, IOException {
        AuthContext authContext = HandlerUtil.getAuth(context, request);
        Authenticator authenticator = this.mock.getAuthenticator();
        if (!authenticator.isAdministrator(authContext)) {
            response.setStatusCode(401);
            return;
        }
        try {
            this.mock.removeBucket(bucket.getName());
        }
        catch (FileNotFoundException ex) {
            response.setStatusCode(404);
        }
    }

    public void register(HttpServer server) {
        server.register("/pools", this.poolHandler);
        server.register(String.format("/pools/%s", this.mock.getPoolName()), this.poolsDefaultHandler);
        server.register(String.format("/pools/%s/buckets", this.mock.getPoolName()), this.allBucketsHandler);
        server.register("/sampleBuckets/install", this.sampleBucketsHandler);
    }

    class CreateBucketBadParamsException
    extends Exception {
        CreateBucketBadParamsException(String message) {
            super(message);
        }
    }
}

