/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.httpio;

import com.couchbase.mock.deps.com.google.gson.JsonElement;
import com.couchbase.mock.deps.com.google.gson.JsonObject;
import com.couchbase.mock.deps.com.google.gson.JsonParser;
import com.couchbase.mock.deps.org.apache.http.Header;
import com.couchbase.mock.deps.org.apache.http.HttpException;
import com.couchbase.mock.deps.org.apache.http.HttpRequest;
import com.couchbase.mock.deps.org.apache.http.HttpResponse;
import com.couchbase.mock.deps.org.apache.http.HttpServerConnection;
import com.couchbase.mock.deps.org.apache.http.entity.ContentType;
import com.couchbase.mock.deps.org.apache.http.entity.StringEntity;
import com.couchbase.mock.deps.org.apache.http.protocol.HttpContext;
import com.couchbase.mock.http.AuthContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class HandlerUtil {
    private HandlerUtil() {
    }

    public static HttpServerConnection getConnection(HttpContext cx) {
        return (HttpServerConnection)cx.getAttribute("http.connection");
    }

    public static Socket getSocket(HttpContext cx) {
        return (Socket)cx.getAttribute("couchbase.mock.http.socket");
    }

    public static URL getUrl(HttpRequest request) throws MalformedURLException {
        String uriStr = request.getRequestLine().getUri();
        try {
            return URI.create(uriStr).toURL();
        }
        catch (IllegalArgumentException ex) {
            return URI.create("http://dummy/" + uriStr).toURL();
        }
    }

    public static JsonObject getJsonQuery(URL url) throws MalformedURLException {
        String query = url.getQuery();
        JsonObject payload = new JsonObject();
        JsonParser parser = new JsonParser();
        if (query == null) {
            return null;
        }
        for (String kv : query.split("&")) {
            JsonElement optVal;
            String[] parts = kv.split("=");
            if (parts.length != 2) {
                throw new MalformedURLException();
            }
            String optName = parts[0];
            try {
                optVal = parser.parse(URLDecoder.decode(parts[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new MalformedURLException();
            }
            payload.add(optName, optVal);
        }
        return payload;
    }

    public static Map<String, String> getQueryParams(String s) throws MalformedURLException {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String kv : s.split("&")) {
            String[] parts = kv.split("=");
            if (parts.length != 2) {
                throw new MalformedURLException();
            }
            try {
                String k = URLDecoder.decode(parts[0], "UTF-8");
                String v = URLDecoder.decode(parts[1], "UTF-8");
                params.put(k, v);
            }
            catch (UnsupportedEncodingException ex) {
                throw new MalformedURLException(ex.getMessage());
            }
        }
        return params;
    }

    public static void makeStringResponse(HttpResponse response, String s) {
        StringEntity entity = new StringEntity(s, ContentType.TEXT_PLAIN);
        entity.setContentEncoding("utf-8");
        response.setEntity(entity);
    }

    public static void makeResponse(HttpResponse response, String msg, int status) {
        response.setStatusCode(status);
        HandlerUtil.makeStringResponse(response, msg);
    }

    public static void make400Response(HttpResponse response, String msg) {
        HandlerUtil.makeResponse(response, msg, 400);
    }

    public static void makeJsonResponse(HttpResponse response, String encoded) {
        StringEntity ent = new StringEntity(encoded, ContentType.APPLICATION_JSON);
        response.setEntity(ent);
    }

    public static void bailResponse(HttpContext cx, HttpResponse response) throws IOException, HttpException {
        HttpServerConnection conn = HandlerUtil.getConnection(cx);
        conn.sendResponseHeader(response);
        conn.sendResponseEntity(response);
        conn.flush();
    }

    public static AuthContext getAuth(HttpContext cx, HttpRequest req) throws IOException {
        AuthContext auth = (AuthContext)cx.getAttribute("couchbase.mock.http.auth");
        if (auth == null) {
            Header authHdr = req.getLastHeader("Authorization");
            auth = authHdr == null ? new AuthContext() : new AuthContext(authHdr.getValue());
        }
        return auth;
    }
}

