/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock;

import com.couchbase.mock.BucketConfiguration;
import com.couchbase.mock.CouchbaseBucket;
import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.Info;
import com.couchbase.mock.JsonUtils;
import com.couchbase.mock.MemcachedBucket;
import com.couchbase.mock.http.BucketAdminServer;
import com.couchbase.mock.http.capi.CAPIServer;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.Storage;
import com.couchbase.mock.memcached.VBucketInfo;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Bucket {
    private CAPIServer capiServer = null;
    private BucketAdminServer adminServer = null;
    protected final VBucketInfo[] vbInfo;
    protected final MemcachedServer[] servers;
    protected final int numVBuckets;
    protected final int numReplicas;
    protected final String poolName = "default";
    protected final String name;
    protected final CouchbaseMock cluster;
    protected final String password;
    protected final ReentrantReadWriteLock configurationRwLock;
    private final UUID uuid;

    public VBucketInfo[] getVBucketInfo() {
        return this.vbInfo;
    }

    public MemcachedServer[] getServers() {
        return this.servers;
    }

    private Iterator<Item> getMasterItemsIterator(final Storage.StorageType type) {
        return new Iterator<Item>(){
            private int curIndex = -1;
            private Iterator<Item> curIterator = this.getNextIterator();

            private Iterator<Item> getNextIterator() {
                if (++this.curIndex == Bucket.this.servers.length) {
                    return null;
                }
                MemcachedServer s = Bucket.this.servers[this.curIndex];
                return s.getStorage().getMasterStore(type).iterator();
            }

            @Override
            public boolean hasNext() {
                while (!this.curIterator.hasNext()) {
                    this.curIterator = this.getNextIterator();
                    if (this.curIterator != null) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Item next() {
                return this.curIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<Item> getMasterItems(final Storage.StorageType type) {
        return new Iterable<Item>(){

            @Override
            public Iterator<Item> iterator() {
                return Bucket.this.getMasterItemsIterator(type);
            }
        };
    }

    public short getVbIndexForKey(String key) {
        return -1;
    }

    public Bucket(CouchbaseMock cluster, BucketConfiguration config) throws IOException {
        int ii;
        if (config.numVBuckets < 0) {
            throw new IllegalArgumentException("Vbucket count must be > 0");
        }
        if ((config.numVBuckets & config.numVBuckets - 1) != 0) {
            throw new IllegalArgumentException("vBucket count must be a power of 2");
        }
        this.cluster = cluster;
        this.name = config.name;
        this.numVBuckets = config.numVBuckets;
        this.numReplicas = config.numReplicas;
        this.password = config.password;
        this.vbInfo = new VBucketInfo[this.numVBuckets];
        this.servers = new MemcachedServer[config.numNodes];
        this.uuid = UUID.randomUUID();
        this.configurationRwLock = new ReentrantReadWriteLock();
        for (ii = 0; ii < this.vbInfo.length; ++ii) {
            this.vbInfo[ii] = new VBucketInfo();
        }
        if (this.getClass() != MemcachedBucket.class && this.getClass() != CouchbaseBucket.class) {
            throw new FileNotFoundException("I don't know about this type...");
        }
        for (ii = 0; ii < this.servers.length; ++ii) {
            this.servers[ii] = new MemcachedServer(this, config.hostname, config.bucketStartPort == 0 ? 0 : config.bucketStartPort + ii, this.vbInfo, cluster.isCccpBootstrap());
        }
        this.rebalance();
    }

    public static Bucket create(CouchbaseMock mock, BucketConfiguration config) throws IOException {
        switch (config.type) {
            case MEMCACHED: {
                return new MemcachedBucket(mock, config);
            }
            case COUCHBASE: {
                return new CouchbaseBucket(mock, config);
            }
        }
        throw new FileNotFoundException("I don't know about this type...");
    }

    public abstract BucketType getType();

    void setCAPIServer(CAPIServer server) {
        this.capiServer = server;
    }

    public CAPIServer getCAPIServer() {
        return this.capiServer;
    }

    void setAdminServer(BucketAdminServer adminServer) {
        this.adminServer = adminServer;
    }

    public BucketAdminServer getAdminServer() {
        return this.adminServer;
    }

    public abstract Map<String, Object> getConfigMap();

    protected Map<String, Object> getCommonConfig() {
        HashMap<String, Object> mm = new HashMap<String, Object>();
        mm.put("replicaNumber", this.numReplicas);
        HashMap<String, Integer> ramQuota = new HashMap<String, Integer>();
        ramQuota.put("rawRAM", 0x6400000);
        ramQuota.put("ram", 0x6400000);
        mm.put("quota", ramQuota);
        return mm;
    }

    public final String getJSON() {
        return JsonUtils.encode(this.getConfigMap());
    }

    public void configReadLock() {
        this.configurationRwLock.readLock().lock();
    }

    public void configReadUnlock() {
        this.configurationRwLock.readLock().unlock();
    }

    public abstract ErrorCode storeItem(String var1, byte[] var2);

    public void failover(int index, boolean rebalance) {
        this.configurationRwLock.writeLock().lock();
        try {
            Info.incrementConfigRevision();
            if (index >= 0 && index < this.servers.length) {
                this.servers[index].shutdown();
            }
            if (rebalance) {
                this.rebalance();
            }
        }
        finally {
            Info.incrementConfigRevision();
            this.configurationRwLock.writeLock().unlock();
        }
    }

    public void respawn(int index) {
        this.configurationRwLock.writeLock().lock();
        try {
            if (index >= 0 && index < this.servers.length) {
                this.servers[index].startup();
            }
            this.rebalance();
        }
        finally {
            Info.incrementConfigRevision();
            this.configurationRwLock.writeLock().unlock();
        }
    }

    void start() {
        for (int ii = 0; ii < this.servers.length; ++ii) {
            this.servers[ii].setName(String.format("%s:MCD[%d]", this.name, ii));
            this.servers[ii].setDaemon(true);
            this.servers[ii].start();
        }
    }

    void stop() {
        for (MemcachedServer t : this.servers) {
            t.interrupt();
            do {
                try {
                    t.join();
                    t = null;
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(CouchbaseMock.class.getName()).log(Level.SEVERE, null, ex);
                    t.interrupt();
                }
            } while (t != null);
        }
    }

    public List<MemcachedServer> activeServers() {
        ArrayList<MemcachedServer> active = new ArrayList<MemcachedServer>(this.servers.length);
        for (MemcachedServer server : this.servers) {
            if (!server.isActive()) continue;
            active.add(server);
        }
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void rebalance() {
        this.configurationRwLock.writeLock().lock();
        try {
            Info.incrementConfigRevision();
            List<MemcachedServer> nodes = this.activeServers();
            for (int ii = 0; ii < this.numVBuckets; ++ii) {
                Collections.shuffle(nodes);
                this.vbInfo[ii].setOwner(nodes.get(0));
                if (nodes.size() < 2) continue;
                List<MemcachedServer> replicas = nodes.subList(1, nodes.size());
                if (replicas.size() > this.numReplicas) {
                    replicas = replicas.subList(0, this.numReplicas);
                }
                this.vbInfo[ii].setReplicas(replicas);
            }
        }
        finally {
            Info.incrementConfigRevision();
            this.configurationRwLock.writeLock().unlock();
        }
    }

    public void regenCoords() {
        for (VBucketInfo cur : this.vbInfo) {
            cur.regenerateUuid();
        }
        for (MemcachedServer s : this.servers) {
            s.getStorage().updateCoordinateInfo(this.vbInfo);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    public String getUUID() {
        return this.uuid.toString();
    }

    public CouchbaseMock getCluster() {
        return this.cluster;
    }

    public int getCarrierPort() {
        List<MemcachedServer> aServers = this.activeServers();
        if (aServers.isEmpty()) {
            throw new RuntimeException("No servers exist for bucket");
        }
        MemcachedServer aServer = aServers.get(0);
        return aServer.getPort();
    }

    public static enum BucketType {
        MEMCACHED,
        COUCHBASE;

    }
}

