/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.BucketConfiguration;
import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.Info;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.KeySpec;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.VBucketStore;
import com.couchbase.mock.memcached.protocol.Datatype;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;

public class CouchbaseBucket
extends Bucket {
    public CouchbaseBucket(CouchbaseMock cluster, BucketConfiguration config) throws IOException {
        super(cluster, config);
    }

    @Override
    public short getVbIndexForKey(String key) {
        CRC32 crc32 = new CRC32();
        crc32.update(key.getBytes());
        long digest = crc32.getValue() >> 16 & 0x7FFFL;
        long vbKey = digest & (long)(this.vbInfo.length - 1);
        return (short)vbKey;
    }

    @Override
    public Map<String, Object> getConfigMap() {
        Map<String, Object> map = this.getCommonConfig();
        List<MemcachedServer> active = this.activeServers();
        map.put("rev", Info.getConfigRevision());
        map.put("name", this.name);
        map.put("bucketType", "membase");
        map.put("authType", "sasl");
        map.put("saslPassword", this.getPassword());
        map.put("proxyPort", 0);
        map.put("uri", "/pools/default/buckets/" + this.name);
        map.put("streamingUri", "/pools/default/bucketsStreaming/" + this.name);
        map.put("flushCacheUri", "/pools/default/buckets/" + this.name + "/controller/doFlush");
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        ArrayList nodesExt = new ArrayList();
        for (MemcachedServer server : active) {
            Map<String, Object> nodeInfo = server.toNodeConfigInfo();
            HashMap<String, Object> svcsTopLevel = new HashMap<String, Object>();
            HashMap<String, Integer> svcsInfo = new HashMap<String, Integer>();
            svcsTopLevel.put("services", svcsInfo);
            if (this.cluster != null) {
                String capiBase = String.format("http://%s:%d/%s", server.getHostname(), this.cluster.getHttpPort(), this.name);
                nodeInfo.put("couchApiBase", capiBase);
                svcsTopLevel.put("hostname", server.getHostname());
                svcsInfo.put("mgmt", this.cluster.getHttpPort());
                svcsInfo.put("n1ql", this.cluster.getHttpPort());
                svcsInfo.put("capi", this.cluster.getHttpPort());
            }
            nodes.add(nodeInfo);
            svcsInfo.put("kv", server.getPort());
            nodesExt.add(svcsTopLevel);
        }
        map.put("nodes", nodes);
        map.put("nodesExt", nodesExt);
        HashMap<String, String> stats = new HashMap<String, String>();
        stats.put("uri", "/pools/default/buckets/" + this.name + "/stats");
        map.put("stats", stats);
        map.put("nodeLocator", "vbucket");
        HashMap<String, Object> vbm = new HashMap<String, Object>();
        vbm.put("hashAlgorithm", "CRC");
        vbm.put("numReplicas", this.numReplicas);
        ArrayList<String> serverList = new ArrayList<String>();
        for (MemcachedServer server : active) {
            serverList.add(server.getSocketName());
        }
        vbm.put("serverList", serverList);
        ArrayList m = new ArrayList();
        for (int ii = 0; ii < this.numVBuckets; ii = (int)((short)(ii + 1))) {
            MemcachedServer master = this.vbInfo[ii].getOwner();
            List<MemcachedServer> replicas = this.vbInfo[ii].getReplicas();
            ArrayList<Integer> line = new ArrayList<Integer>();
            line.add(active.indexOf(master));
            for (MemcachedServer replica : replicas) {
                line.add(active.indexOf(replica));
            }
            while (line.size() - 1 < this.numReplicas) {
                line.add(-1);
            }
            m.add(line);
        }
        vbm.put("vBucketMap", m);
        map.put("vBucketServerMap", vbm);
        map.put("bucketCapabilitiesVer", "");
        map.put("bucketCapabilities", Arrays.asList("cbhello", "touch", "couchapi", "cccp", "nodesExt"));
        return map;
    }

    @Override
    public Bucket.BucketType getType() {
        return Bucket.BucketType.COUCHBASE;
    }

    @Override
    public ErrorCode storeItem(String key, byte[] value) {
        short vbIndex = this.getVbIndexForKey(key);
        KeySpec ks = new KeySpec(key, vbIndex);
        Item item = new Item(ks, 0, 0, value, null, 0L, Datatype.RAW.value());
        MemcachedServer server = this.vbInfo[vbIndex].getOwner();
        VBucketStore vbStore = server.getStorage().getCache(vbIndex);
        return vbStore.set(item, false).getStatus();
    }
}

