/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.http;

import com.couchbase.mock.util.Base64;
import java.io.IOException;

public class AuthContext {
    private String username;
    private String password;

    public AuthContext(String hdr) throws IOException {
        String[] parts = hdr.split(" ");
        if (parts.length != 2) {
            throw new IOException("Invalid auth header");
        }
        if (!parts[0].equals("Basic")) {
            throw new IOException("Non-Basic auth not supported");
        }
        String b64 = parts[1];
        String decoded = Base64.decode(b64);
        if ((parts = decoded.split(":", 2)).length != 2) {
            throw new IOException("Don't know what to do with " + decoded);
        }
        this.username = parts[0];
        this.password = parts[1];
    }

    public AuthContext() {
        this.username = "";
        this.password = "";
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

