/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.http;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.JsonUtils;
import com.couchbase.mock.deps.org.apache.http.HttpException;
import com.couchbase.mock.deps.org.apache.http.HttpRequest;
import com.couchbase.mock.deps.org.apache.http.HttpResponse;
import com.couchbase.mock.deps.org.apache.http.HttpServerConnection;
import com.couchbase.mock.deps.org.apache.http.entity.ContentType;
import com.couchbase.mock.deps.org.apache.http.protocol.HttpContext;
import com.couchbase.mock.deps.org.apache.http.protocol.HttpRequestHandler;
import com.couchbase.mock.http.BucketsStreamingHandler;
import com.couchbase.mock.http.HttpAuthVerifier;
import com.couchbase.mock.http.StateGrabber;
import com.couchbase.mock.http.capi.CAPIServer;
import com.couchbase.mock.httpio.HandlerUtil;
import com.couchbase.mock.httpio.HttpServer;
import com.couchbase.mock.httpio.ResponseHandledException;
import com.couchbase.mock.memcached.MemcachedServer;
import java.io.IOException;
import java.net.Socket;
import java.util.Map;

public final class BucketAdminServer {
    private final CouchbaseMock mock;
    private final HttpAuthVerifier verifier;
    private final Bucket bucket;
    private final HttpServer parentServer;
    private static final String FMT_ONESHOT = "%s/buckets/%s";
    private static final String FMT_STREAM = "%s/bucketsStreaming/%s";
    private static final String FMT_TERSE_ONESHOT = "%s/b/%s";
    private static final String FMT_TERSE_STREAM = "%s/bs/%s";
    private static final String FMT_DOFLUSH = "%s/buckets/%s/controller/doFlush";
    private static final String FMT_DDOCS = "%s/buckets/%s/ddocs";

    public BucketAdminServer(Bucket bucket, HttpServer server, CouchbaseMock mock) {
        this.bucket = bucket;
        this.mock = mock;
        this.parentServer = server;
        this.verifier = new HttpAuthVerifier(bucket, mock.getAuthenticator());
    }

    private String getPoolPrefix() {
        return String.format("/pools/%s", this.mock.getPoolName());
    }

    public void register() {
        String prefix = this.getPoolPrefix();
        this.parentServer.register(String.format(FMT_ONESHOT, prefix, this.bucket.getName()), new OneShotHandler());
        this.parentServer.register(String.format(FMT_STREAM, prefix, this.bucket.getName()), new StreamingHandler());
        this.parentServer.register(String.format(FMT_TERSE_ONESHOT, prefix, this.bucket.getName()), new OneShotHandler());
        this.parentServer.register(String.format(FMT_TERSE_STREAM, prefix, this.bucket.getName()), new StreamingHandler());
        this.parentServer.register(String.format(FMT_DOFLUSH, prefix, this.bucket.getName()), new FlushHandler());
        this.parentServer.register(String.format(FMT_DDOCS, prefix, this.bucket.getName()), new DesignDocsHandler());
    }

    public void shutdown() {
        String prefix = this.getPoolPrefix();
        for (String s : new String[]{FMT_ONESHOT, FMT_STREAM, FMT_DOFLUSH, FMT_DDOCS}) {
            String path = String.format(s, prefix, this.bucket.getName());
            this.parentServer.unregister(path);
        }
    }

    private class OneShotHandler
    implements HttpRequestHandler {
        private OneShotHandler() {
        }

        @Override
        public void handle(HttpRequest req, HttpResponse response, HttpContext context) throws HttpException, IOException {
            if (!BucketAdminServer.this.verifier.verify(req, response, context)) {
                return;
            }
            String methodName = req.getRequestLine().getMethod();
            if (methodName.equals("GET")) {
                HandlerUtil.makeJsonResponse(response, StateGrabber.getBucketJSON(BucketAdminServer.this.bucket));
            } else if (methodName.equals("DELETE")) {
                BucketAdminServer.this.mock.getPoolsHandler().handleDeleteBucket(req, response, context, BucketAdminServer.this.bucket);
            } else {
                response.setStatusCode(501);
            }
        }
    }

    private class StreamingHandler
    implements HttpRequestHandler {
        private StreamingHandler() {
        }

        @Override
        public void handle(HttpRequest req, HttpResponse response, HttpContext context) throws HttpException, IOException {
            if (!BucketAdminServer.this.verifier.verify(req, response, context)) {
                return;
            }
            HttpServerConnection htConn = HandlerUtil.getConnection(context);
            response.setHeader("Transfer-Encoding", "chunked");
            response.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
            response.setHeader("Connection", "Close");
            response.removeHeaders("Content-Length");
            htConn.sendResponseHeader(response);
            htConn.flush();
            Socket s = HandlerUtil.getSocket(context);
            BucketsStreamingHandler streamingHandler = new BucketsStreamingHandler(BucketAdminServer.this.mock.getMonitor(), BucketAdminServer.this.bucket, s);
            try {
                streamingHandler.startStreaming();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            throw new ResponseHandledException();
        }
    }

    private class FlushHandler
    implements HttpRequestHandler {
        private FlushHandler() {
        }

        @Override
        public void handle(HttpRequest req, HttpResponse response, HttpContext context) throws HttpException, IOException {
            if (!BucketAdminServer.this.verifier.verify(req, response, context)) {
                return;
            }
            for (MemcachedServer server : BucketAdminServer.this.bucket.getServers()) {
                server.flushAll();
            }
        }
    }

    private class DesignDocsHandler
    implements HttpRequestHandler {
        private DesignDocsHandler() {
        }

        @Override
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            if (!BucketAdminServer.this.verifier.verify(request, response, context)) {
                return;
            }
            CAPIServer capi = BucketAdminServer.this.bucket.getCAPIServer();
            if (capi == null) {
                HandlerUtil.makeStringResponse(response, "Not found");
                response.setStatusCode(404);
                return;
            }
            Map<String, Object> ddInfo = capi.getDddocApiInfo();
            String encoded = JsonUtils.encode(ddInfo);
            HandlerUtil.makeJsonResponse(response, encoded);
        }
    }
}

