/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

import com.couchbase.mock.memcached.protocol.BinaryCommand;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class BinaryHelloCommand
extends BinaryCommand {
    private boolean isProcessed = false;
    private boolean[] features = new boolean[Feature.MAX.getValue()];

    public BinaryHelloCommand(ByteBuffer header) throws ProtocolException {
        super(header);
    }

    @Override
    public void process() throws ProtocolException {
        if (this.isProcessed) {
            return;
        }
        ByteBuffer bb = ByteBuffer.wrap(this.getValue());
        while (bb.hasRemaining()) {
            short feature = bb.getShort();
            if (feature < 0 || feature > Feature.MAX.value - 1) continue;
            this.features[feature] = true;
        }
        this.isProcessed = true;
    }

    public boolean[] getFeatures() {
        return Arrays.copyOf(this.features, this.features.length);
    }

    public static enum Feature {
        DATATYPE(1),
        TLS(2),
        TCP_NODELAY(3),
        MUTATION_SEQNO(4),
        XATTR(6),
        XERROR(7),
        SELECT_BUCKET(8),
        COLLECTIONS(9),
        SNAPPY(10),
        JSON(11),
        DUPLEX(12),
        CLUSTERMAP_CHANGE_NOTIFICATION(13),
        UNORDERED_EXECUTION(14),
        TRACING(15),
        MAX(16);

        private final int value;

        private Feature(int value) {
            this.value = value;
        }

        public static Feature valueOf(int value) {
            for (Feature feature : Feature.values()) {
                if (feature.value != value) continue;
                return feature;
            }
            return null;
        }

        public int getValue() {
            return this.value;
        }
    }
}

