/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

import com.couchbase.mock.memcached.protocol.BinarySubdocCommand;
import com.couchbase.mock.memcached.protocol.BinarySubdocMultiCommand;
import com.couchbase.mock.memcached.protocol.CommandCode;
import com.couchbase.mock.subdoc.Executor;
import com.couchbase.mock.subdoc.Operation;
import java.net.ProtocolException;
import java.nio.ByteBuffer;

public class BinarySubdocMultiMutationCommand
extends BinarySubdocMultiCommand {
    public BinarySubdocMultiMutationCommand(ByteBuffer header) throws ProtocolException {
        super(header);
    }

    @Override
    protected void extractSpecs() throws ProtocolException {
        while (this.bodyBuffer.hasRemaining()) {
            byte bOp = this.bodyBuffer.get();
            byte flags = this.bodyBuffer.get();
            short pathLength = this.bodyBuffer.getShort();
            int valueLength = this.bodyBuffer.getInt();
            byte[] path = new byte[pathLength];
            byte[] value = new byte[valueLength];
            this.bodyBuffer.get(path);
            this.bodyBuffer.get(value);
            Operation subdocOp = BinarySubdocCommand.toSubdocOpcode(CommandCode.valueOf(bOp));
            this.specs.add(new BinarySubdocMultiCommand.MultiSpec(subdocOp, new String(path), new String(value), flags));
        }
    }

    public final String getRootType() {
        for (BinarySubdocMultiCommand.MultiSpec spec : this.specs) {
            String rootString = Executor.getRootType(spec.getPath(), spec.getOp());
            if (rootString == null) continue;
            return rootString;
        }
        return null;
    }
}

