/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.control.handlers;

import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.control.CommandStatus;
import com.couchbase.mock.control.MockCommand;
import com.couchbase.mock.control.handlers.KeyCommandHandler;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.KeySpec;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.VBucketInfo;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class KeyInfoCommandHandler
extends KeyCommandHandler {
    private String result;

    private static Map<String, Object> itemToString(Item itm) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (itm != null) {
            byte[] value = itm.getValue();
            String valueString = null;
            if (value != null) {
                valueString = new String(value);
            }
            ret.put("Value", valueString);
            ret.put("CAS", itm.getCas());
        }
        return ret;
    }

    private static Map<String, Object> configToString(MemcachedServer server, KeySpec ks) {
        VBucketInfo vbi = server.getStorage().getVBucketInfo(ks.vbId);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (vbi.getOwner() == server) {
            ret.put("Index", 0);
            ret.put("Type", "master");
        } else {
            ret.put("Index", vbi.getReplicas().indexOf(server) + 1);
            ret.put("Type", "replica");
        }
        return ret;
    }

    private static Map<String, Object> serverKeyStatus(MemcachedServer server, KeySpec ks) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("Cache", KeyInfoCommandHandler.itemToString(server.getStorage().getCached(ks)));
        ret.put("Disk", KeyInfoCommandHandler.itemToString(server.getStorage().getPersisted(ks)));
        ret.put("Conf", KeyInfoCommandHandler.configToString(server, ks));
        return ret;
    }

    @Override
    @NotNull
    public CommandStatus execute(@NotNull CouchbaseMock mock, @NotNull MockCommand.Command command, @NotNull JsonObject payload) {
        super.execute(mock, command, payload);
        ArrayList<Map<String, Object>> infoList = new ArrayList<Map<String, Object>>();
        List<MemcachedServer> vbiServers = this.vbi.getAllServers();
        for (MemcachedServer server : this.bucket.getServers()) {
            if (!vbiServers.contains(server)) {
                infoList.add(null);
                continue;
            }
            Map<String, Object> skInfo = KeyInfoCommandHandler.serverKeyStatus(server, this.keySpec);
            infoList.add(skInfo);
        }
        CommandStatus ret = new CommandStatus();
        ret.setPayload(infoList);
        return ret;
    }
}

