/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.http.capi;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.JsonUtils;
import com.couchbase.mock.http.HttpAuthVerifier;
import com.couchbase.mock.http.capi.DesignHandler;
import com.couchbase.mock.http.capi.PathInfo;
import com.couchbase.mock.http.capi.ViewHandler;
import com.couchbase.mock.httpio.HandlerUtil;
import com.couchbase.mock.httpio.HttpServer;
import com.couchbase.mock.views.DesignDocument;
import com.couchbase.mock.views.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpResponse;

public final class CAPIServer {
    private final Bucket bucket;
    final HttpAuthVerifier verifier;
    private final Map<String, DesignDocument> designDocMap;
    private HttpServer parentServer = null;
    static final Set<String> ALLOWED_DDOC_METHODS = new HashSet<String>();
    private static final String TXT_NOTFOUND = "{\"error\":\"not_found\",\"reason\":\"missing\"}\n";

    public CAPIServer(Bucket bucket, HttpAuthVerifier verifier) {
        this.bucket = bucket;
        this.verifier = verifier;
        this.designDocMap = new ConcurrentHashMap<String, DesignDocument>();
    }

    public void register(HttpServer server) {
        DesignHandler designServer = new DesignHandler(this);
        String prefix = String.format("/%s/_design/*", this.bucket.getName());
        server.register(prefix, designServer);
        this.parentServer = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map<String, DesignDocument> map = this.designDocMap;
        synchronized (map) {
            for (DesignDocument ddoc : this.designDocMap.values()) {
                this.removeDesign(ddoc, false);
            }
        }
        this.parentServer.unregister(String.format("%s/_design/*", this.bucket.getName()));
    }

    private String makeViewPaths(DesignDocument design, View view) {
        return String.format("/%s/%s/_view/%s", this.bucket.getName(), design.getId(), view.getName());
    }

    private void handleViewPaths(DesignDocument design, boolean enabled) {
        for (View view : design.getViews()) {
            String path = this.makeViewPaths(design, view);
            if (enabled) {
                System.err.printf("Registering name '%s'\n", path);
                this.parentServer.register(path, new ViewHandler(view, this.bucket));
                continue;
            }
            this.parentServer.unregister(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDesign(DesignDocument design, boolean needSync) {
        DesignDocument oldDocument;
        if (needSync) {
            Map<String, DesignDocument> map = this.designDocMap;
            synchronized (map) {
                oldDocument = this.designDocMap.remove(design.getId());
            }
        } else {
            oldDocument = this.designDocMap.remove(design.getId());
        }
        if (oldDocument != null) {
            this.handleViewPaths(design, false);
        }
    }

    public void removeDesign(DesignDocument design) {
        this.removeDesign(design, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDesign(DesignDocument design) {
        Map<String, DesignDocument> map = this.designDocMap;
        synchronized (map) {
            this.removeDesign(design, false);
            this.handleViewPaths(design, true);
            this.designDocMap.put(design.getId(), design);
        }
    }

    DesignDocument findDesign(PathInfo info) {
        return this.designDocMap.get(info.getDesignId());
    }

    private Map<String, Object> getSingleViewInfo(View view) {
        HashMap<String, Object> topLevel = new HashMap<String, Object>();
        String sMap = view.getMapSource();
        String sRed = view.getReduceSource();
        if (sMap != null) {
            topLevel.put("map", sMap);
        }
        if (sRed != null) {
            topLevel.put("reduce", sRed);
        }
        return topLevel;
    }

    private Map<String, Object> getSingleDdocInfo(DesignDocument ddoc) {
        HashMap<String, Object> topLevel = new HashMap<String, Object>();
        topLevel.put("controllers", new HashMap());
        HashMap doc = new HashMap();
        topLevel.put("doc", doc);
        HashMap<String, Object> meta = new HashMap<String, Object>();
        doc.put("meta", meta);
        meta.put("id", ddoc.getId());
        meta.put("rev", ddoc.hashCode());
        HashMap<String, Object> json = new HashMap<String, Object>();
        doc.put("json", json);
        json.put("_id", ddoc.getId());
        json.put("language", "javascript");
        HashMap<String, Map<String, Object>> views = new HashMap<String, Map<String, Object>>();
        json.put("views", views);
        for (View view : ddoc.getViews()) {
            Map<String, Object> viewInfo = this.getSingleViewInfo(view);
            views.put(view.getName(), viewInfo);
        }
        return topLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getDddocApiInfo() {
        HashMap<String, Object> retvalOuterObject = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> retvalRows = new ArrayList<Map<String, Object>>();
        retvalOuterObject.put("rows", retvalRows);
        Map<String, DesignDocument> map = this.designDocMap;
        synchronized (map) {
            for (DesignDocument ddoc : this.designDocMap.values()) {
                retvalRows.add(this.getSingleDdocInfo(ddoc));
            }
        }
        return retvalOuterObject;
    }

    public static String makeError(String errStr, String reasonStr) {
        HashMap<String, String> mm = new HashMap<String, String>();
        mm.put("error", errStr);
        mm.put("reason", reasonStr);
        return JsonUtils.encode(mm) + "\n";
    }

    public static String makeError(String reasonStr) {
        return CAPIServer.makeError("unknown_error", reasonStr);
    }

    public static void makeNotFoundError(HttpResponse response) {
        HandlerUtil.makeJsonResponse(response, TXT_NOTFOUND);
        response.setStatusCode(404);
    }

    public static void makeNotFoundError(HttpResponse response, String detail) {
        String s = CAPIServer.makeError("not_found", detail);
        s = s + "\n";
        HandlerUtil.makeJsonResponse(response, s);
        response.setStatusCode(404);
    }

    static {
        ALLOWED_DDOC_METHODS.add("GET");
        ALLOWED_DDOC_METHODS.add("PUT");
        ALLOWED_DDOC_METHODS.add("HEAD");
        ALLOWED_DDOC_METHODS.add("DELETE");
    }
}

