/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.httpio;

import com.couchbase.mock.Info;
import com.couchbase.mock.httpio.ResponseHandledException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.ServerSocketChannel;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.DefaultBHttpServerConnectionFactory;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;
import org.apache.http.util.VersionInfo;

public class HttpServer
extends Thread {
    private volatile boolean shouldRun = true;
    private final DefaultBHttpServerConnectionFactory connectionFactory;
    private final HttpService httpService;
    private final UriHttpRequestHandlerMapper registry;
    private final Set<Worker> allWorkers = new HashSet<Worker>();
    private static final String serverString = String.format("CouchbaseMock/%s (mcd; views) httpcomponents/%s", Info.getVersion(), VersionInfo.loadVersionInfo("org.apache.http", null).getRelease());
    private ServerSocketChannel listener;
    public static final String CX_SOCKET = "couchbase.mock.http.socket";
    public static final String CX_AUTH = "couchbase.mock.http.auth";

    public HttpServer() {
        this.connectionFactory = new DefaultBHttpServerConnectionFactory();
        this.registry = new MyRequestHandlerMapper();
        HttpProcessor httpProcessor = HttpProcessorBuilder.create().add(new ResponseServer(serverString)).add(new ResponseContent()).add(new ResponseConnControl()).build();
        this.httpService = new MyHttpService(httpProcessor, this.registry);
        this.register("*", new HttpRequestHandler(){

            @Override
            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                response.setStatusCode(404);
            }
        });
    }

    public void bind(InetSocketAddress address) throws IOException {
        if (this.listener != null) {
            this.listener.close();
            this.listener = null;
        }
        this.listener = ServerSocketChannel.open();
        this.listener.socket().bind(address);
    }

    public void bind(ServerSocketChannel newSock) {
        this.listener = newSock;
    }

    public void register(String pattern, HttpRequestHandler handler) {
        this.registry.register(pattern, handler);
        this.registry.register(pattern + "/", handler);
    }

    public void unregister(String pattern) {
        this.registry.unregister(pattern);
        this.registry.unregister(pattern + "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("Mock HTTP Listener: " + this.listener.socket().getInetAddress());
        while (this.shouldRun) {
            try {
                Socket incoming = this.listener.accept().socket();
                DefaultBHttpServerConnection conn = this.connectionFactory.createConnection(incoming);
                Worker worker = new Worker(conn, incoming);
                Set<Worker> set = this.allWorkers;
                synchronized (set) {
                    this.allWorkers.add(worker);
                }
                worker.start();
            }
            catch (IOException ex) {
                if (!this.shouldRun) continue;
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        this.shouldRun = false;
        try {
            this.listener.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (true) {
            Set<Worker> set = this.allWorkers;
            synchronized (set) {
                if (this.allWorkers.isEmpty()) {
                    break;
                }
                for (Worker w : this.allWorkers) {
                    w.stopSocket();
                    w.interrupt();
                }
            }
        }
        try {
            this.listener.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    class Worker
    extends Thread {
        final HttpServerConnection htConn;
        final Socket rawSocket;
        private volatile boolean closeRequested = false;

        Worker(HttpServerConnection htConn, Socket rawSocket) {
            this.htConn = htConn;
            this.rawSocket = rawSocket;
            this.setName("Mock Http Worker: " + rawSocket.getRemoteSocketAddress());
        }

        void stopSocket() {
            this.closeRequested = true;
            try {
                this.rawSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void bail() {
            this.stopSocket();
        }

        public void doReadLoop() {
            BasicHttpContext context = new BasicHttpContext();
            context.setAttribute(HttpServer.CX_SOCKET, this.rawSocket);
            while (!Thread.interrupted() && this.htConn.isOpen() && HttpServer.this.shouldRun) {
                context.removeAttribute(HttpServer.CX_AUTH);
                try {
                    HttpServer.this.httpService.handleRequest(this.htConn, context);
                }
                catch (ConnectionClosedException ex_closed) {
                    break;
                }
                catch (IOException ex) {
                    if (this.closeRequested) break;
                    ex.printStackTrace();
                    break;
                }
                catch (HttpException ex) {
                    ex.printStackTrace();
                    break;
                }
                catch (ResponseHandledException ex) {
                    // empty catch block
                    break;
                }
            }
            this.bail();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.doReadLoop();
            }
            finally {
                Set set = HttpServer.this.allWorkers;
                synchronized (set) {
                    HttpServer.this.allWorkers.remove(this);
                }
                this.bail();
            }
        }
    }

    static class MyRequestHandlerMapper
    extends UriHttpRequestHandlerMapper {
        MyRequestHandlerMapper() {
        }

        @Override
        protected String getRequestPath(HttpRequest request) {
            String s = request.getRequestLine().getUri();
            try {
                URI uri = new URI(s);
                return uri.getPath();
            }
            catch (URISyntaxException ex) {
                return s;
            }
            catch (IllegalArgumentException ex) {
                return s;
            }
        }
    }

    static class MyHttpService
    extends HttpService {
        MyHttpService(HttpProcessor proc, UriHttpRequestHandlerMapper registry) {
            super(proc, registry);
        }

        @Override
        protected void doService(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.addHeader("Cache-Control", "must-revalidate");
            super.doService(request, response, context);
        }
    }
}

