/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

public enum ErrorCode {
    SUCCESS(0),
    KEY_ENOENT(1),
    KEY_EEXISTS(2),
    E2BIG(3),
    EINVAL(4),
    NOT_STORED(5),
    DELTA_BADVAL(6),
    NOT_MY_VBUCKET(7),
    AUTH_ERROR(32),
    AUTH_CONTINUE(33),
    UNKNOWN_COMMAND(129),
    ENOMEM(130),
    NOT_SUPPORTED(131),
    EINTERNAL(132),
    EBUSY(133),
    ETMPFAIL(134),
    EACCESS(36),
    SUBDOC_PATH_ENOENT(192),
    SUBDOC_PATH_MISMATCH(193),
    SUBDOC_PATH_EINVAL(194),
    SUBDOC_PATH_E2BIG(195),
    SUBDOC_DOC_E2DEEP(196),
    SUBDOC_VALUE_CANTINSERT(197),
    SUBDOC_DOC_NOTJSON(198),
    SUBDOC_NUM_ERANGE(199),
    SUBDOC_DELTA_ERANGE(200),
    SUBDOC_PATH_EEXISTS(201),
    SUBDOC_VALUE_E2DEEP(202),
    SUBDOC_INVALID_COMBO(203),
    SUBDOC_MULTI_FAILURE(204),
    DUMMY_RETRY_CONSTANT(32752),
    DUMMY_RETRY_LINEAR(32753),
    DUMMY_RETRY_EXPONENTIAL(32754);

    private final short value;

    private ErrorCode(int value) {
        this.value = (short)value;
    }

    public short value() {
        return this.value;
    }

    public static ErrorCode valueOf(short value) {
        for (ErrorCode code : ErrorCode.values()) {
            if (code.value != value) continue;
            return code;
        }
        throw new IllegalArgumentException("Unknown status code " + value);
    }
}

