/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.util;

import java.util.ArrayList;
import java.util.List;

public class Getopt {
    private int optind = -1;
    private final List<CommandLineOption> options = new ArrayList<CommandLineOption>();

    public Getopt addOption(CommandLineOption option) {
        this.options.add(option);
        return this;
    }

    public List<Entry> parse(String[] argv) {
        int idx;
        this.optind = -1;
        ArrayList<Entry> ret = new ArrayList<Entry>();
        for (idx = 0; idx < argv.length; ++idx) {
            if (argv[idx].equals("--")) {
                ++idx;
                break;
            }
            if (argv[idx].charAt(0) != '-') break;
            if (argv[idx].startsWith("--")) {
                idx = this.parseLongOption(argv, ret, idx);
                continue;
            }
            if (!argv[idx].startsWith("-")) break;
            idx = this.parseShortOption(argv, ret, idx);
        }
        if (idx != argv.length) {
            this.optind = idx;
        }
        return ret;
    }

    private int parseShortOption(String[] argv, List<Entry> ret, int idx) {
        String keys = argv[idx].substring(1);
        for (char c : keys.toCharArray()) {
            String key = "-" + c;
            boolean found = false;
            for (CommandLineOption o : this.options) {
                if (key.charAt(1) != o.shortOption) continue;
                found = true;
                String value = null;
                if (o.hasArgument) {
                    if (idx + 1 < argv.length) {
                        value = argv[idx + 1];
                        ++idx;
                    } else {
                        throw new IllegalArgumentException("option requires an argument -- " + key);
                    }
                }
                ret.add(new Entry(key, value));
            }
            if (found) continue;
            throw new IllegalArgumentException("Illegal option -- " + key);
        }
        return idx;
    }

    private int parseLongOption(String[] argv, List<Entry> ret, int idx) {
        String key = argv[idx];
        int ii = key.indexOf(61);
        if (ii != -1) {
            key = key.substring(0, ii);
        }
        boolean found = false;
        for (CommandLineOption o : this.options) {
            if (!key.equals(o.longOption)) continue;
            found = true;
            String value = null;
            if (o.hasArgument) {
                if (ii != -1) {
                    value = argv[idx].substring(ii + 1);
                } else if (idx + 1 < argv.length) {
                    value = argv[idx + 1];
                    ++idx;
                } else {
                    throw new IllegalArgumentException("option requires an argument -- " + key);
                }
            }
            ret.add(new Entry(key, value));
        }
        if (!found) {
            throw new IllegalArgumentException("Illegal option -- " + key);
        }
        return idx;
    }

    public int getOptind() {
        return this.optind;
    }

    public static class Entry {
        public final String key;
        public final String value;

        public Entry(String k, String v) {
            this.key = k;
            this.value = v;
        }
    }

    public static class CommandLineOption {
        private final char shortOption;
        private final String longOption;
        private final boolean hasArgument;

        public CommandLineOption(char shortOption, String longOption, boolean hasArgument) {
            this.shortOption = shortOption;
            this.longOption = longOption;
            this.hasArgument = hasArgument;
        }
    }
}

