/*
 * Decompiled with CFR 0.152.
 */
package services;

import java.io.IOException;
import models.Audience;
import models.AudienceMembers;
import models.Audiences;
import models.PutAudienceBody;
import models.PutAudienceResponse;
import services.AudiencesInterface;
import services.Courier;

public class AudiencesService {
    private final AudiencesInterface audiencesInterface = (AudiencesInterface)Courier.getRetrofit().create(AudiencesInterface.class);

    public Audience getAudience(String audienceId) throws IOException {
        return (Audience)this.audiencesInterface.getAudience(audienceId, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public PutAudienceResponse putAudience(PutAudienceBody audience) throws IOException {
        return (PutAudienceResponse)this.audiencesInterface.putAudience(audience.getId(), audience, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public AudienceMembers getAudienceMembers(String audienceId, String cursor) throws IOException {
        return (AudienceMembers)this.audiencesInterface.getAudienceMembers(audienceId, cursor, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public Audiences getAudiences(String cursor) throws IOException {
        return (Audiences)this.audiencesInterface.getAudiences(cursor, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }
}

