/*
 * Decompiled with CFR 0.152.
 */
package services;

import java.io.IOException;
import models.Brand;
import models.BrandCreateBody;
import models.BrandUpdateBody;
import models.Brands;
import services.BrandsInterface;
import services.Courier;

public class BrandsService {
    private final BrandsInterface brandsInterface = (BrandsInterface)Courier.getRetrofit().create(BrandsInterface.class);

    public Brands getBrands() throws IOException {
        return (Brands)this.brandsInterface.getBrands(Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public Brand getBrand(String brandId) throws IOException {
        return (Brand)this.brandsInterface.getBrand(brandId, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public Brand postBrand(BrandCreateBody brand) throws IOException {
        return (Brand)this.brandsInterface.postBrand(brand, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public Brand putBrand(String brandId, BrandUpdateBody brand) throws IOException {
        return (Brand)this.brandsInterface.putBrand(brandId, brand, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public void deleteBrand(String brandId) throws IOException {
        this.brandsInterface.deleteBrand(brandId, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute();
    }
}

