/*
 * Decompiled with CFR 0.152.
 */
package services;

import java.io.IOException;
import models.BulkCreateJobRequestBody;
import models.BulkCreateJobResponseBody;
import models.BulkGetJobResponseBody;
import models.BulkIngestUsersRequestBody;
import models.BulkIngestUsersResponseBody;
import models.BulkJobUsers;
import services.BulkInterface;
import services.Courier;

public class BulkService {
    private final BulkInterface bulkInterface = (BulkInterface)Courier.getRetrofit().create(BulkInterface.class);

    public BulkCreateJobResponseBody createJob(BulkCreateJobRequestBody bulkCreateJobRequestBody) throws IOException {
        return (BulkCreateJobResponseBody)this.bulkInterface.createJob(bulkCreateJobRequestBody, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public BulkIngestUsersResponseBody ingestUsers(String jobId, BulkIngestUsersRequestBody bulkIngestUsersRequestBody) throws IOException {
        return (BulkIngestUsersResponseBody)this.bulkInterface.ingestUsers(jobId, bulkIngestUsersRequestBody, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public void runJob(String jobId) throws IOException {
        this.bulkInterface.runJob(jobId, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public BulkGetJobResponseBody getJob(String jobId) throws IOException {
        return (BulkGetJobResponseBody)this.bulkInterface.getJob(jobId, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public BulkJobUsers getJobUsers(String jobId, String cursor) throws IOException {
        return (BulkJobUsers)this.bulkInterface.getJobUsers(jobId, cursor, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }
}

