/*
 * Decompiled with CFR 0.152.
 */
package services;

import java.util.Base64;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Courier {
    private static String baseUrl = "https://api.courier.com/";
    private static String authToken;
    private static String username;
    private static String password;
    private static String authorizationHeader;
    private static Retrofit retrofit;
    private static String version;

    private Courier() {
    }

    public static synchronized void init() {
        Courier.init(null, null, null, null);
    }

    public static synchronized void init(String authToken) {
        Courier.init(null, authToken, null, null);
    }

    public static synchronized void init(String baseUrl, String authToken) {
        Courier.init(baseUrl, authToken, null, null);
    }

    public static synchronized void init(String baseUrl, String authToken, String username, String password) {
        if (baseUrl != null) {
            Courier.baseUrl = baseUrl;
        } else if (System.getenv("COURIER_BASE_URL") != null) {
            Courier.baseUrl = System.getenv("COURIER_BASE_URL");
        }
        if (authToken != null) {
            Courier.authToken = authToken;
            authorizationHeader = "Bearer " + authToken;
        } else if (System.getenv("COURIER_AUTH_TOKEN") != null) {
            Courier.authToken = System.getenv("COURIER_AUTH_TOKEN");
            authorizationHeader = "Bearer " + System.getenv("COURIER_AUTH_TOKEN");
        } else if (username != null && password != null) {
            Courier.username = username;
            Courier.password = password;
            authorizationHeader = "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
        } else if (System.getenv("COURIER_AUTH_USERNAME") != null && System.getenv("COURIER_AUTH_PASSWORD") != null) {
            Courier.username = System.getenv("COURIER_AUTH_USERNAME");
            Courier.password = System.getenv("COURIER_AUTH_PASSWORD");
            authorizationHeader = "Basic " + Base64.getEncoder().encodeToString((System.getenv("COURIER_AUTH_USERNAME") + ":" + System.getenv("COURIER_AUTH_PASSWORD")).getBytes());
        }
        retrofit = Courier.buildRetrofit();
    }

    public static String getBaseUrl() {
        return baseUrl;
    }

    public static String getAuthorizationHeader() {
        return authorizationHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Retrofit getRetrofit() {
        if (retrofit == null) return retrofit;
        Class<Courier> clazz = Courier.class;
        synchronized (Courier.class) {
            if (retrofit != null) return retrofit;
            retrofit = Courier.buildRetrofit();
            // ** MonitorExit[var0] (shouldn't be in output)
            return retrofit;
        }
    }

    private static Retrofit buildRetrofit() {
        return new Retrofit.Builder().baseUrl(Courier.getBaseUrl()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
    }

    public static String getUserAgent() {
        return "courier-java/" + version;
    }

    static {
        version = "1.8.0";
    }
}

