/*
 * Decompiled with CFR 0.152.
 */
package services;

import models.List;
import models.ListBulkSubscriptionUpdate;
import models.ListSubscriptions;
import models.ListUpdateBody;
import models.PureLists;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ListsInterface {
    @GET(value="/lists")
    public Call<PureLists> getLists(@Query(value="cursor") String var1, @Query(value="pattern") String var2, @Header(value="Authorization") String var3, @Header(value="User-Agent") String var4);

    @GET(value="/lists/{listId}")
    public Call<List> getList(@Path(value="listId") String var1, @Header(value="Authorization") String var2, @Header(value="User-Agent") String var3);

    @PUT(value="/lists/{listId}")
    public Call<Void> putList(@Path(value="listId") String var1, @Body ListUpdateBody var2, @Header(value="Authorization") String var3, @Header(value="User-Agent") String var4);

    @DELETE(value="/lists/{listId}")
    public Call<Void> deleteList(@Path(value="listId") String var1, @Header(value="Authorization") String var2, @Header(value="User-Agent") String var3);

    @PUT(value="/lists/{listId}/restore")
    public Call<Void> restoreList(@Path(value="listId") String var1, @Header(value="Authorization") String var2, @Header(value="User-Agent") String var3);

    @GET(value="/lists/{listId}/subscriptions")
    public Call<ListSubscriptions> getListSubscriptions(@Path(value="listId") String var1, @Query(value="cursor") String var2, @Header(value="Authorization") String var3, @Header(value="User-Agent") String var4);

    @PUT(value="/lists/{listId}/subscriptions")
    public Call<Void> bulkSubscribeRecipientsToList(@Path(value="listId") String var1, @Body ListBulkSubscriptionUpdate var2, @Header(value="Authorization") String var3, @Header(value="User-Agent") String var4);

    @PUT(value="/lists/{listId}/subscriptions/{recipientId}")
    public Call<Void> subscribeRecipientToList(@Path(value="listId") String var1, @Path(value="recipientId") String var2, @Header(value="Authorization") String var3, @Header(value="User-Agent") String var4);

    @DELETE(value="/lists/{listId}/subscriptions/{recipientId}")
    public Call<Void> unsubscribeRecipientFromList(@Path(value="listId") String var1, @Path(value="recipientId") String var2, @Header(value="Authorization") String var3, @Header(value="User-Agent") String var4);
}

