/*
 * Decompiled with CFR 0.152.
 */
package services;

import java.io.IOException;
import models.List;
import models.ListBulkSubscriptionUpdate;
import models.ListSubscriptions;
import models.ListUpdateBody;
import models.PureLists;
import services.Courier;
import services.ListsInterface;

public class ListsService {
    private final ListsInterface listsInterface = (ListsInterface)Courier.getRetrofit().create(ListsInterface.class);

    public PureLists getLists(String cursor, String pattern) throws IOException {
        return (PureLists)this.listsInterface.getLists(cursor, pattern, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public List getList(String listId) throws IOException {
        return (List)this.listsInterface.getList(listId, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public void putList(String listId, ListUpdateBody listUpdateBody) throws IOException {
        this.listsInterface.putList(listId, listUpdateBody, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute();
    }

    public void deleteList(String listId) throws IOException {
        this.listsInterface.deleteList(listId, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute();
    }

    public void restoreList(String listId) throws IOException {
        this.listsInterface.restoreList(listId, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute();
    }

    public ListSubscriptions getListSubscriptions(String listId, String cursor) throws IOException {
        return (ListSubscriptions)this.listsInterface.getListSubscriptions(listId, cursor, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public void bulkSubscribeRecipientToList(String listId, ListBulkSubscriptionUpdate bulkSubscriptionUpdate) throws IOException {
        this.listsInterface.bulkSubscribeRecipientsToList(listId, bulkSubscriptionUpdate, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute();
    }

    public void subscribeRecipientToList(String listId, String recipientId) throws IOException {
        this.listsInterface.subscribeRecipientToList(listId, recipientId, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute();
    }

    public void unsubscribeRecipientFromList(String listId, String recipientId) throws IOException {
        this.listsInterface.unsubscribeRecipientFromList(listId, recipientId, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute();
    }
}

