/*
 * Decompiled with CFR 0.152.
 */
package services;

import java.io.IOException;
import models.PatchRequestBody;
import models.Profile;
import models.ProfileLists;
import models.UpdateResponseBody;
import services.Courier;
import services.ProfilesInterface;

public class ProfilesService {
    private final ProfilesInterface profilesInterface = (ProfilesInterface)Courier.getRetrofit().create(ProfilesInterface.class);

    public Profile getProfile(String recipientId) throws IOException {
        return (Profile)this.profilesInterface.getProfile(recipientId, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public UpdateResponseBody postProfile(String recipientId, Profile profile) throws IOException {
        return (UpdateResponseBody)this.profilesInterface.postProfile(recipientId, profile, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public UpdateResponseBody patchProfile(String recipientId, PatchRequestBody patchRequestBody) throws IOException {
        return (UpdateResponseBody)this.profilesInterface.patchProfile(recipientId, patchRequestBody, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public UpdateResponseBody putProfile(String recipientId, Profile profile) throws IOException {
        return (UpdateResponseBody)this.profilesInterface.putProfile(recipientId, profile, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }

    public ProfileLists getProfileLists(String recipientId, String cursor) throws IOException {
        return (ProfileLists)this.profilesInterface.getProfileLists(recipientId, cursor, Courier.getAuthorizationHeader(), Courier.getUserAgent()).execute().body();
    }
}

