/*
 * Decompiled with CFR 0.152.
 */
package com.coveo;

import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractFMT
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.sourceDirectory}", property="sourceDirectory", required=true)
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", property="testSourceDirectory", required=true)
    private File testSourceDirectory;
    @Parameter(defaultValue="${project.packaging}", required=true)
    private String packaging;
    @Parameter(property="additionalSourceDirectories")
    private File[] additionalSourceDirectories;
    @Parameter(defaultValue="false", property="verbose")
    private boolean verbose;
    @Parameter(defaultValue="false", property="failOnUnknownFolder")
    private boolean failOnUnknownFolder;
    @Parameter(defaultValue=".*\\.java", property="filesNamePattern")
    private String filesNamePattern;
    @Parameter(defaultValue="false", property="fmt.skip")
    private boolean skip = false;
    @Parameter(defaultValue="false", property="skipSortingImports")
    private boolean skipSortingImports = false;
    @Parameter(defaultValue="google", property="style")
    private String style;
    private List<String> filesProcessed = new ArrayList<String>();
    private int nonComplyingFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping format check");
            return;
        }
        if ("pom".equals(this.packaging)) {
            this.getLog().info((CharSequence)"Skipping format check: project uses 'pom' packaging");
            return;
        }
        if (this.skipSortingImports) {
            this.getLog().info((CharSequence)"Skipping sorting imports");
        }
        ArrayList<File> directoriesToFormat = new ArrayList<File>();
        if (this.sourceDirectory.exists()) {
            directoriesToFormat.add(this.sourceDirectory);
        } else {
            this.handleMissingDirectory("Source", this.sourceDirectory);
        }
        if (this.testSourceDirectory.exists()) {
            directoriesToFormat.add(this.testSourceDirectory);
        } else {
            this.handleMissingDirectory("Test source", this.testSourceDirectory);
        }
        for (File additionalSourceDirectory : this.additionalSourceDirectories) {
            if (additionalSourceDirectory.exists()) {
                directoriesToFormat.add(additionalSourceDirectory);
                continue;
            }
            this.handleMissingDirectory("Additional source", additionalSourceDirectory);
        }
        Formatter formatter = this.getFormatter();
        for (File directoryToFormat : directoriesToFormat) {
            this.formatSourceFilesInDirectory(directoryToFormat, formatter);
        }
        this.logNumberOfFilesProcessed();
        this.postExecute(this.filesProcessed, this.nonComplyingFiles);
    }

    protected void postExecute(List<String> filesProcessed, int nonComplyingFiles) throws MojoFailureException {
    }

    public List<String> getFilesProcessed() {
        return this.filesProcessed;
    }

    public void formatSourceFilesInDirectory(File directory, Formatter formatter) throws MojoFailureException {
        if (!directory.isDirectory()) {
            this.getLog().info((CharSequence)("Directory '" + directory + "' is not a directory. Skipping."));
            return;
        }
        try (Stream<Path> paths = Files.walk(Paths.get(directory.getPath(), new String[0]), new FileVisitOption[0]);){
            paths.collect(Collectors.toList()).parallelStream().filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).filter(file -> this.getFileFilter().accept((File)file)).forEach(file -> this.formatSourceFile((File)file, formatter));
        }
        catch (IOException exception) {
            throw new MojoFailureException(exception.getMessage());
        }
    }

    private JavaFormatterOptions.Style style() throws MojoFailureException {
        if ("aosp".equalsIgnoreCase(this.style)) {
            this.getLog().debug((CharSequence)"Using AOSP style");
            return JavaFormatterOptions.Style.AOSP;
        }
        if ("google".equalsIgnoreCase(this.style)) {
            this.getLog().debug((CharSequence)"Using Google style");
            return JavaFormatterOptions.Style.GOOGLE;
        }
        String message = "Unknown style '" + this.style + "'. Expected 'google' or 'aosp'.";
        this.getLog().error((CharSequence)message);
        throw new MojoFailureException(message);
    }

    private Formatter getFormatter() throws MojoFailureException {
        return new Formatter(JavaFormatterOptions.builder().style(this.style()).build());
    }

    private FileFilter getFileFilter() {
        if (this.verbose) {
            this.getLog().debug((CharSequence)("Filter files on '" + this.filesNamePattern + "'."));
        }
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().matches(AbstractFMT.this.filesNamePattern);
            }
        };
    }

    private void formatSourceFile(File file, Formatter formatter) {
        if (file.isDirectory()) {
            this.getLog().info((CharSequence)("File '" + file + "' is a directory. Skipping."));
            return;
        }
        if (this.verbose) {
            this.getLog().debug((CharSequence)("Formatting '" + file + "'."));
        }
        CharSource source = com.google.common.io.Files.asCharSource((File)file, (Charset)Charsets.UTF_8);
        try {
            String input = source.read();
            String formatted = formatter.formatSource(input);
            formatted = RemoveUnusedImports.removeUnusedImports((String)formatted, (RemoveUnusedImports.JavadocOnlyImports)RemoveUnusedImports.JavadocOnlyImports.KEEP);
            if (!this.skipSortingImports) {
                formatted = ImportOrderer.reorderImports((String)formatted);
            }
            if (!input.equals(formatted)) {
                this.onNonComplyingFile(file, formatted);
                ++this.nonComplyingFiles;
            }
            this.filesProcessed.add(file.getAbsolutePath());
            if (this.filesProcessed.size() % 100 == 0) {
                this.logNumberOfFilesProcessed();
            }
        }
        catch (FormatterException | IOException e) {
            this.getLog().warn((CharSequence)("Failed to format file '" + file + "'."), e);
        }
    }

    private void handleMissingDirectory(String directoryDisplayName, File directory) throws MojoFailureException {
        if (this.failOnUnknownFolder) {
            String message = directoryDisplayName + " directory '" + directory + "' does not exist, failing build (failOnUnknownFolder is true).";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        this.getLog().warn((CharSequence)(directoryDisplayName + " directory '" + directory + "' does not exist, ignoring."));
    }

    protected void logNumberOfFilesProcessed() {
        this.getLog().info((CharSequence)String.format("Processed %d files (%d %s).", this.filesProcessed.size(), this.nonComplyingFiles, this.getProcessingLabel()));
    }

    protected abstract void onNonComplyingFile(File var1, String var2) throws IOException;

    protected abstract String getProcessingLabel();
}

