/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.configuration.parameterstore;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagementClientBuilder;
import com.coveo.configuration.parameterstore.ParameterStorePropertySource;
import com.coveo.configuration.parameterstore.ParameterStoreSource;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ObjectUtils;

public class ParameterStorePropertySourceEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    static final String PARAMETER_STORE_ACCEPTED_PROFILE = "awsParameterStorePropertySourceEnabled";
    static final String PARAMETER_STORE_ACCEPTED_PROFILES_CONFIGURATION_PROPERTY = "awsParameterStorePropertySource.enabledProfiles";
    static final String PARAMETER_STORE_ENABLED_CONFIGURATION_PROPERTY = "awsParameterStorePropertySource.enabled";
    static final String PARAMETER_STORE_HALT_BOOT_CONFIGURATION_PROPERTY = "awsParameterStorePropertySource.haltBoot";
    static final String PARAMETER_STORE_CLIENT_ENDPOINT_CONFIGURATION_PROPERTY = "awsParameterStoreSource.ssmClient.endpointConfiguration.endpoint";
    static final String PARAMETER_STORE_CLIENT_ENDPOINT_SIGNING_REGION_CONFIGURATION_PROPERTY = "awsParameterStoreSource.ssmClient.endpointConfiguration.signingRegion";
    private static final String PARAMETER_STORE_PROPERTY_SOURCE_NAME = "AWSParameterStorePropertySource";
    static boolean initialized;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!initialized && this.isParameterStorePropertySourceEnabled(environment)) {
            environment.getPropertySources().addFirst((PropertySource)new ParameterStorePropertySource(PARAMETER_STORE_PROPERTY_SOURCE_NAME, new ParameterStoreSource(this.buildAWSSimpleSystemsManagementClient(environment), (Boolean)environment.getProperty(PARAMETER_STORE_HALT_BOOT_CONFIGURATION_PROPERTY, Boolean.class, (Object)Boolean.FALSE))));
            initialized = true;
        }
    }

    private boolean isParameterStorePropertySourceEnabled(ConfigurableEnvironment environment) {
        Object[] userDefinedEnabledProfiles = (String[])environment.getProperty(PARAMETER_STORE_ACCEPTED_PROFILES_CONFIGURATION_PROPERTY, String[].class);
        return (Boolean)environment.getProperty(PARAMETER_STORE_ENABLED_CONFIGURATION_PROPERTY, Boolean.class, (Object)Boolean.FALSE) != false || environment.acceptsProfiles(new String[]{PARAMETER_STORE_ACCEPTED_PROFILE}) || !ObjectUtils.isEmpty((Object[])userDefinedEnabledProfiles) && environment.acceptsProfiles((String[])userDefinedEnabledProfiles);
    }

    private AWSSimpleSystemsManagement buildAWSSimpleSystemsManagementClient(ConfigurableEnvironment environment) {
        if (environment.containsProperty(PARAMETER_STORE_CLIENT_ENDPOINT_CONFIGURATION_PROPERTY)) {
            return (AWSSimpleSystemsManagement)((AWSSimpleSystemsManagementClientBuilder)AWSSimpleSystemsManagementClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(environment.getProperty(PARAMETER_STORE_CLIENT_ENDPOINT_CONFIGURATION_PROPERTY), environment.getProperty(PARAMETER_STORE_CLIENT_ENDPOINT_SIGNING_REGION_CONFIGURATION_PROPERTY, new DefaultAwsRegionProviderChain().getRegion())))).build();
        }
        return AWSSimpleSystemsManagementClientBuilder.defaultClient();
    }
}

