/*
 * Decompiled with CFR 0.152.
 */
package com.coxautodata.utils;

import com.coxautodata.SparkDistCPOptions;
import com.coxautodata.objects.CopyActionResult;
import com.coxautodata.objects.CopyActionResult$Copied$;
import com.coxautodata.objects.CopyActionResult$Created$;
import com.coxautodata.objects.CopyActionResult$OverwrittenOrUpdated$;
import com.coxautodata.objects.CopyActionResult$SkippedAlreadyExists$;
import com.coxautodata.objects.CopyActionResult$SkippedDryRun$;
import com.coxautodata.objects.CopyActionResult$SkippedIdenticalFileAlreadyExists$;
import com.coxautodata.objects.DeleteActionResult;
import com.coxautodata.objects.DeleteActionResult$Deleted$;
import com.coxautodata.objects.DeleteActionResult$SkippedDoesNotExists$;
import com.coxautodata.objects.DeleteActionResult$SkippedDryRun$;
import com.coxautodata.objects.DeleteResult;
import com.coxautodata.objects.DirectoryCopyResult;
import com.coxautodata.objects.DistCPResult;
import com.coxautodata.objects.FileCopyResult;
import com.coxautodata.objects.Logging;
import com.coxautodata.objects.SerializableFileStatus;
import com.coxautodata.objects.SerializableFileStatus$;
import com.coxautodata.objects.SingleCopyDefinition;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class CopyUtils$
implements Logging {
    public static CopyUtils$ MODULE$;
    private final Logger com$coxautodata$objects$Logging$$log;

    static {
        new CopyUtils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void setLogLevel(Level level) {
        Logging.setLogLevel$(this, level);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger com$coxautodata$objects$Logging$$log() {
        return this.com$coxautodata$objects$Logging$$log;
    }

    @Override
    public final void com$coxautodata$objects$Logging$_setter_$com$coxautodata$objects$Logging$$log_$eq(Logger x$1) {
        this.com$coxautodata$objects$Logging$$log = x$1;
    }

    public DistCPResult handleCopy(FileSystem sourceFS, FileSystem destFS, SingleCopyDefinition definition, SparkDistCPOptions options, long taskAttemptID) {
        Product product;
        if (options.verbose()) {
            this.setLogLevel(Level.DEBUG);
        }
        if (definition.source().isDirectory()) {
            product = this.createDirectory(destFS, definition, options);
        } else if (definition.source().isFile()) {
            product = this.copyFile(sourceFS, destFS, definition, options, taskAttemptID);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(60).append("Given file is neither file nor directory. Copy unsupported: ").append(definition.source().getPath()).toString());
        }
        DirectoryCopyResult r = product;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> r.getMessage());
        return r;
    }

    public DeleteResult handleDelete(FileSystem fs, URI uri, SparkDistCPOptions options) {
        if (options.verbose()) {
            this.setLogLevel(Level.DEBUG);
        }
        Path path = new Path(uri);
        DeleteResult r = this.deleteFile(fs, path, options);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> r.getMessage());
        return r;
    }

    /*
     * Unable to fully structure code
     */
    public DeleteResult deleteFile(FileSystem fs, Path path, SparkDistCPOptions options) {
        block5: {
            block8: {
                block10: {
                    block9: {
                        block7: {
                            block6: {
                                block4: {
                                    if (fs.exists(path)) break block4;
                                    v0 = new DeleteResult(path.toUri(), DeleteActionResult$SkippedDoesNotExists$.MODULE$);
                                    break block5;
                                }
                                if (!options.dryRun()) break block6;
                                v0 = new DeleteResult(path.toUri(), DeleteActionResult$SkippedDryRun$.MODULE$);
                                break block5;
                            }
                            var5_4 = false;
                            var6_5 = null;
                            var7_6 = false;
                            var8_7 = null;
                            var9_8 = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$deleteFile$1(org.apache.hadoop.fs.FileSystem org.apache.hadoop.fs.Path ), ()Z)((FileSystem)fs, (Path)path));
                            if (!(var9_8 instanceof Success)) break block7;
                            var5_4 = true;
                            var6_5 = (Success)var9_8;
                            var10_9 = BoxesRunTime.unboxToBoolean((Object)var6_5.value());
                            if (!var10_9) break block7;
                            var4_10 = new DeleteResult(path.toUri(), DeleteActionResult$Deleted$.MODULE$);
                            break block8;
                        }
                        if (!var5_4 || (var11_11 = BoxesRunTime.unboxToBoolean((Object)var6_5.value())) || fs.exists(path)) break block9;
                        var4_10 = new DeleteResult(path.toUri(), DeleteActionResult$SkippedDoesNotExists$.MODULE$);
                        break block8;
                    }
                    if (!var5_4 || (var12_12 = BoxesRunTime.unboxToBoolean((Object)var6_5.value())) || !options.ignoreErrors()) break block10;
                    var4_10 = new DeleteResult(path.toUri(), new DeleteActionResult.Failed(new RuntimeException(new StringBuilder(30).append("Failed to delete directory [").append(path).append("].").toString())));
                    break block8;
                }
                if (var5_4 && !(var13_13 = BoxesRunTime.unboxToBoolean((Object)var6_5.value()))) {
                    throw new RuntimeException(new StringBuilder(30).append("Failed to delete directory [").append(path).append("].").toString());
                }
                if (!(var9_8 instanceof Failure)) ** GOTO lbl-1000
                var7_6 = true;
                var8_7 = (Failure)var9_8;
                e = var8_7.exception();
                if (options.ignoreErrors()) {
                    var4_10 = new DeleteResult(path.toUri(), new DeleteActionResult.Failed(e));
                } else lbl-1000:
                // 2 sources

                {
                    if (var7_6) {
                        e = var8_7.exception();
                        throw e;
                    }
                    throw new MatchError((Object)var9_8);
                }
            }
            v0 = var4_10;
        }
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    public DirectoryCopyResult createDirectory(FileSystem destFS, SingleCopyDefinition definition, SparkDistCPOptions options) {
        block4: {
            block7: {
                block6: {
                    block5: {
                        block3: {
                            destPath = new Path(definition.destination());
                            if (!destFS.exists(destPath)) break block3;
                            v0 = new DirectoryCopyResult(definition.source().getPath().toUri(), definition.destination(), CopyActionResult$SkippedAlreadyExists$.MODULE$);
                            break block4;
                        }
                        if (!options.dryRun()) break block5;
                        v0 = new DirectoryCopyResult(definition.source().getPath().toUri(), definition.destination(), CopyActionResult$SkippedDryRun$.MODULE$);
                        break block4;
                    }
                    result = Try$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$createDirectory$1(org.apache.hadoop.fs.FileSystem org.apache.hadoop.fs.Path com.coxautodata.objects.SingleCopyDefinition ), ()Lcom/coxautodata/objects/DirectoryCopyResult;)((FileSystem)destFS, (Path)destPath, (SingleCopyDefinition)definition)).recover((PartialFunction)new scala.Serializable(definition){
                        public static final long serialVersionUID = 0L;
                        private final SingleCopyDefinition definition$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            Object object = A1 instanceof FileAlreadyExistsException ? new DirectoryCopyResult(this.definition$1.source().getPath().toUri(), this.definition$1.destination(), CopyActionResult$SkippedAlreadyExists$.MODULE$) : function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            boolean bl = throwable instanceof FileAlreadyExistsException;
                            return bl;
                        }
                        {
                            this.definition$1 = definition$1;
                        }
                    });
                    var7_6 = false;
                    var8_7 = null;
                    var9_8 = result;
                    if (!(var9_8 instanceof Success)) break block6;
                    var10_9 = (Success)var9_8;
                    var4_11 = v = (DirectoryCopyResult)var10_9.value();
                    break block7;
                }
                if (!(var9_8 instanceof Failure)) ** GOTO lbl-1000
                var7_6 = true;
                var8_7 = (Failure)var9_8;
                e = var8_7.exception();
                if (options.ignoreErrors()) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$createDirectory$2(com.coxautodata.objects.SingleCopyDefinition ), ()Ljava/lang/String;)((SingleCopyDefinition)definition), e);
                    var4_11 = new DirectoryCopyResult(definition.source().getPath().toUri(), definition.destination(), new CopyActionResult.Failed(e));
                } else lbl-1000:
                // 2 sources

                {
                    if (var7_6) {
                        e = var8_7.exception();
                        throw e;
                    }
                    throw new MatchError((Object)var9_8);
                }
            }
            v0 = var4_11;
        }
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    public FileCopyResult copyFile(FileSystem sourceFS, FileSystem destFS, SingleCopyDefinition definition, SparkDistCPOptions options, long taskAttemptID) {
        block11: {
            block16: {
                block18: {
                    block17: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        block10: {
                                            destPath = new Path(definition.destination());
                                            var10_7 = false;
                                            var11_8 = null;
                                            var12_9 = false;
                                            var13_10 = null;
                                            var14_11 = Try$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$copyFile$1(org.apache.hadoop.fs.FileSystem org.apache.hadoop.fs.Path ), ()Lorg/apache/hadoop/fs/FileStatus;)((FileSystem)destFS, (Path)destPath));
                                            if (!(var14_11 instanceof Failure)) break block10;
                                            var10_7 = true;
                                            var11_8 = (Failure)var14_11;
                                            if (!(var11_8.exception() instanceof FileNotFoundException) || !options.dryRun()) break block10;
                                            var7_12 = new FileCopyResult(definition.source().getPath().toUri(), definition.destination(), definition.source().len(), CopyActionResult$SkippedDryRun$.MODULE$);
                                            break block11;
                                        }
                                        if (!var10_7 || !(var11_8.exception() instanceof FileNotFoundException)) break block12;
                                        var7_12 = this.performCopy(sourceFS, definition.source(), destFS, definition.destination(), false, options.ignoreErrors(), taskAttemptID);
                                        break block11;
                                    }
                                    if (!var10_7) break block13;
                                    e = var11_8.exception();
                                    if (!options.ignoreErrors()) break block13;
                                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$copyFile$2(com.coxautodata.objects.SingleCopyDefinition ), ()Ljava/lang/String;)((SingleCopyDefinition)definition), e);
                                    var7_12 = new FileCopyResult(definition.source().getPath().toUri(), definition.destination(), definition.source().len(), new CopyActionResult.Failed(e));
                                    break block11;
                                }
                                if (var10_7) {
                                    e = var11_8.exception();
                                    throw e;
                                }
                                if (!(var14_11 instanceof Success)) break block14;
                                var12_9 = true;
                                var13_10 = (Success)var14_11;
                                if (!options.overwrite() || !options.dryRun()) break block14;
                                var7_12 = new FileCopyResult(definition.source().getPath().toUri(), definition.destination(), definition.source().len(), CopyActionResult$SkippedDryRun$.MODULE$);
                                break block11;
                            }
                            if (!var12_9 || !options.overwrite()) break block15;
                            var7_12 = this.performCopy(sourceFS, definition.source(), destFS, definition.destination(), true, options.ignoreErrors(), taskAttemptID);
                            break block11;
                        }
                        if (!var12_9) break block16;
                        d = (FileStatus)var13_10.value();
                        if (!options.update()) break block16;
                        var18_16 = false;
                        var19_17 = null;
                        var20_18 = false;
                        var21_19 = null;
                        var22_20 = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$copyFile$3(com.coxautodata.objects.SingleCopyDefinition org.apache.hadoop.fs.FileSystem org.apache.hadoop.fs.FileStatus org.apache.hadoop.fs.FileSystem org.apache.hadoop.fs.Path ), ()Z)((SingleCopyDefinition)definition, (FileSystem)sourceFS, (FileStatus)d, (FileSystem)destFS, (Path)destPath));
                        if (!(var22_20 instanceof Failure)) break block17;
                        var18_16 = true;
                        var19_17 = (Failure)var22_20;
                        e = var19_17.exception();
                        if (!options.ignoreErrors()) break block17;
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$copyFile$6(com.coxautodata.objects.SingleCopyDefinition ), ()Ljava/lang/String;)((SingleCopyDefinition)definition), e);
                        var8_22 = new FileCopyResult(definition.source().getPath().toUri(), definition.destination(), definition.source().len(), new CopyActionResult.Failed(e));
                        break block18;
                    }
                    if (var18_16) {
                        e = var19_17.exception();
                        throw e;
                    }
                    if (!(var22_20 instanceof Success)) ** GOTO lbl-1000
                    var20_18 = true;
                    var21_19 = (Success)var22_20;
                    var25_24 = BoxesRunTime.unboxToBoolean((Object)var21_19.value());
                    if (var25_24) {
                        var8_22 = new FileCopyResult(definition.source().getPath().toUri(), definition.destination(), definition.source().len(), CopyActionResult$SkippedIdenticalFileAlreadyExists$.MODULE$);
                    } else if (var20_18 && !(var26_25 = BoxesRunTime.unboxToBoolean((Object)var21_19.value())) && options.dryRun()) {
                        var8_22 = new FileCopyResult(definition.source().getPath().toUri(), definition.destination(), definition.source().len(), CopyActionResult$SkippedDryRun$.MODULE$);
                    } else if (var20_18 && !(var27_26 = BoxesRunTime.unboxToBoolean((Object)var21_19.value()))) {
                        var8_22 = this.performCopy(sourceFS, definition.source(), destFS, definition.destination(), true, options.ignoreErrors(), taskAttemptID);
                    } else {
                        throw new MatchError((Object)var22_20);
                    }
                }
                var7_12 = var8_22;
                break block11;
            }
            if (var12_9) {
                var7_12 = new FileCopyResult(definition.source().getPath().toUri(), definition.destination(), definition.source().len(), CopyActionResult$SkippedAlreadyExists$.MODULE$);
            } else {
                throw new MatchError((Object)var14_11);
            }
        }
        return var7_12;
    }

    public boolean filesAreIdentical(SerializableFileStatus f1, Function0<Option<FileChecksum>> mc1, SerializableFileStatus f2, Function0<Option<FileChecksum>> mc2) {
        boolean bl;
        if (f1.getLen() != f2.getLen()) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Length [").append(f1.getLen()).append("] of file [").append(f1.uri()).append("] was not the same as length [").append(f2.getLen()).append("] of file [").append(f2.uri()).append("]. Files are not identical.").toString());
            bl = false;
        } else {
            Option c12 = (Option)mc1.apply();
            Option c2 = (Option)mc2.apply();
            boolean same = BoxesRunTime.unboxToBoolean((Object)((Option)mc1.apply()).flatMap((Function1 & Serializable & scala.Serializable)c1 -> ((Option)mc2.apply()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CopyUtils$.$anonfun$filesAreIdentical$3(c1, x$1)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
            if (same) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("CRC [").append(c12).append("] of file [").append(f1.uri()).append("] was the same as CRC [").append(c2).append("] of file [").append(f2.uri()).append("]. Files are identical.").toString());
                bl = true;
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("CRC [").append(c12).append("] of file [").append(f1.uri()).append("] was not the same as CRC [").append(c2).append("] of file [").append(f2.uri()).append("]. Files are not identical.").toString());
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileCopyResult performCopy(FileSystem sourceFS, SerializableFileStatus sourceFile, FileSystem destFS, URI dest, boolean removeExisting, boolean ignoreErrors, long taskAttemptID) {
        Path destPath = new Path(dest);
        Path tempPath = new Path(destPath.getParent(), new StringBuilder(14).append(".sparkdistcp.").append(taskAttemptID).append(".").append(destPath.getName()).toString());
        boolean bl = false;
        Success success = null;
        boolean bl2 = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            None$ in = None$.MODULE$;
            None$ out = None$.MODULE$;
            try {
                in = new Some((Object)sourceFS.open(sourceFile.getPath()));
                if (!destFS.exists(tempPath.getParent())) {
                    throw new RuntimeException(new StringBuilder(36).append("Destination folder [").append(tempPath.getParent()).append("] does not exist").toString());
                }
                out = new Some((Object)destFS.create(tempPath, false));
                IOUtils.copyBytes((InputStream)((InputStream)in.get()), (OutputStream)((OutputStream)out.get()), (int)sourceFS.getConf().getInt("io.file.buffer.size", 4096));
            }
            finally {
                in.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.close();
                    return BoxedUnit.UNIT;
                });
                out.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.close();
                    return BoxedUnit.UNIT;
                });
            }
        }).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            CopyUtils$.$anonfun$performCopy$4(destFS, tempPath, sourceFile, removeExisting, destPath, x$3);
            return BoxedUnit.UNIT;
        });
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            if (removeExisting) {
                return new FileCopyResult(sourceFile.getPath().toUri(), dest, sourceFile.len(), CopyActionResult$OverwrittenOrUpdated$.MODULE$);
            }
        }
        if (bl) {
            return new FileCopyResult(sourceFile.getPath().toUri(), dest, sourceFile.len(), CopyActionResult$Copied$.MODULE$);
        }
        if (try_ instanceof Failure) {
            bl2 = true;
            failure = (Failure)try_;
            Throwable e = failure.exception();
            if (ignoreErrors) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Failed to copy file [").append(sourceFile.getPath()).append("] to [").append(destPath).append("]").toString(), e);
                return new FileCopyResult(sourceFile.getPath().toUri(), dest, sourceFile.len(), new CopyActionResult.Failed(e));
            }
        }
        if (!bl2) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        throw e;
    }

    public static final /* synthetic */ boolean $anonfun$deleteFile$1(FileSystem fs$1, Path path$1) {
        return fs$1.delete(path$1, true);
    }

    public static final /* synthetic */ DirectoryCopyResult $anonfun$createDirectory$1(FileSystem destFS$1, Path destPath$1, SingleCopyDefinition definition$1) {
        if (!destFS$1.exists(destPath$1.getParent())) {
            throw new FileNotFoundException(new StringBuilder(32).append("Parent folder [").append(destPath$1.getParent()).append("] does not exist.").toString());
        }
        destFS$1.mkdirs(destPath$1);
        return new DirectoryCopyResult(definition$1.source().getPath().toUri(), definition$1.destination(), CopyActionResult$Created$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$createDirectory$2(SingleCopyDefinition definition$1) {
        return new StringBuilder(38).append("Exception whilst creating directory [").append(definition$1.destination()).append("]").toString();
    }

    public static final /* synthetic */ FileStatus $anonfun$copyFile$1(FileSystem destFS$2, Path destPath$2) {
        return destFS$2.getFileStatus(destPath$2);
    }

    public static final /* synthetic */ String $anonfun$copyFile$2(SingleCopyDefinition definition$2) {
        return new StringBuilder(56).append("Exception whilst getting destination file information [").append(definition$2.destination()).append("]").toString();
    }

    public static final /* synthetic */ boolean $anonfun$copyFile$3(SingleCopyDefinition definition$2, FileSystem sourceFS$1, FileStatus d$1, FileSystem destFS$2, Path destPath$2) {
        return MODULE$.filesAreIdentical(definition$2.source(), (Function0<Option<FileChecksum>>)(Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)sourceFS$1.getFileChecksum(definition$2.source().getPath())), SerializableFileStatus$.MODULE$.apply(d$1), (Function0<Option<FileChecksum>>)(Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)destFS$2.getFileChecksum(destPath$2)));
    }

    public static final /* synthetic */ String $anonfun$copyFile$6(SingleCopyDefinition definition$2) {
        return new StringBuilder(81).append("Exception whilst getting source and destination checksum: source [").append(definition$2.source().getPath()).append("] destination [").append(definition$2.destination()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$filesAreIdentical$3(FileChecksum c1$1, Object x$1) {
        FileChecksum fileChecksum = c1$1;
        Object object = x$1;
        return !(fileChecksum != null ? !fileChecksum.equals(object) : object != null);
    }

    public static final /* synthetic */ void $anonfun$performCopy$4(FileSystem destFS$3, Path tempPath$1, SerializableFileStatus sourceFile$1, boolean removeExisting$1, Path destPath$3, BoxedUnit x$3) {
        boolean res;
        FileStatus tempFile = destFS$3.getFileStatus(tempPath$1);
        if (sourceFile$1.getLen() != tempFile.getLen()) {
            throw new RuntimeException(new StringBuilder(64).append("Written file [").append(tempFile.getPath()).append("] length [").append(tempFile.getLen()).append("] did not match source file [").append(sourceFile$1.getPath()).append("] length [").append(sourceFile$1.getLen()).append("]").toString());
        }
        if (removeExisting$1 && !(res = destFS$3.delete(destPath$3, false))) {
            throw new RuntimeException(new StringBuilder(35).append("Failed to clean up existing file [").append(destPath$3).append("]").toString());
        }
        if (destFS$3.exists(destPath$3)) {
            throw new RuntimeException(new StringBuilder(42).append("Cannot create file [").append(destPath$3).append("] as it already exists").toString());
        }
        boolean res2 = destFS$3.rename(tempPath$1, destPath$3);
        if (!res2) {
            throw new RuntimeException(new StringBuilder(40).append("Failed to rename temporary file [").append(tempPath$1).append("] to [").append(destPath$3).append("]").toString());
        }
    }

    private CopyUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

