/*
 * Decompiled with CFR 0.152.
 */
package com.coxautodata.utils;

import com.coxautodata.SparkDistCPOptions;
import com.coxautodata.objects.CopyDefinitionWithDependencies;
import com.coxautodata.objects.Logging;
import com.coxautodata.objects.SerializableFileStatus;
import com.coxautodata.objects.SerializableFileStatus$;
import com.coxautodata.objects.SingleCopyDefinition;
import com.coxautodata.utils.FileListUtils;
import com.coxautodata.utils.PathUtils$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class FileListUtils$
implements Logging {
    public static FileListUtils$ MODULE$;
    private final Logger com$coxautodata$objects$Logging$$log;

    static {
        new FileListUtils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void setLogLevel(Level level) {
        Logging.setLogLevel$(this, level);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger com$coxautodata$objects$Logging$$log() {
        return this.com$coxautodata$objects$Logging$$log;
    }

    @Override
    public final void com$coxautodata$objects$Logging$_setter_$com$coxautodata$objects$Logging$$log_$eq(Logger x$1) {
        this.com$coxautodata$objects$Logging$$log = x$1;
    }

    public <T> FileListUtils.ScalaRemoteIterator<T> com$coxautodata$utils$FileListUtils$$ScalaRemoteIterator(RemoteIterator<T> underlying) {
        return new FileListUtils.ScalaRemoteIterator<T>(underlying);
    }

    public Seq<Tuple2<SerializableFileStatus, Seq<SerializableFileStatus>>> listFiles(FileSystem fs, Path path, int threads, boolean includePathRootInDependents, List<Regex> filterNot) {
        Predef$.MODULE$.assert(threads > 0, (Function0 & Serializable & scala.Serializable)() -> "Number of threads must be positive");
        None$ maybePathRoot = includePathRootInDependents ? new Some((Object)SerializableFileStatus$.MODULE$.apply(fs.getFileStatus(path))) : None$.MODULE$;
        LinkedBlockingQueue processed = new LinkedBlockingQueue((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(Option$.MODULE$.option2Iterable(maybePathRoot.map((Function1 & Serializable & scala.Serializable)x$1 -> new Tuple2(x$1, (Object)Nil$.MODULE$))).toSeq()).asJava());
        LinkedBlockingDeque toProcess = new LinkedBlockingDeque((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new Tuple2((Object)path, (Object)Option$.MODULE$.option2Iterable((Option)maybePathRoot).toSeq()), (List)Nil$.MODULE$)).asJava());
        ConcurrentLinkedQueue exceptions = new ConcurrentLinkedQueue();
        ConcurrentHashMap threadsWorking = new ConcurrentHashMap();
        ExecutorService pool = Executors.newFixedThreadPool(threads);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Beginning recursive list of [").append(path).append("]").toString());
        Seq tasks = (Seq)((List)((List)List$.MODULE$.fill(threads, (Function0 & Serializable & scala.Serializable)() -> {
            public class Com_coxautodata_utils_FileListUtils$FileLister$1
            implements Runnable {
                private final FileSystem localFS;
                private final UUID uuid;
                private final ConcurrentHashMap threadsWorking$1;
                private final LinkedBlockingDeque toProcess$1;
                private final List filterNot$1;
                private final LinkedBlockingQueue processed$1;
                private final ConcurrentLinkedQueue exceptions$1;

                private FileSystem localFS() {
                    return this.localFS;
                }

                private UUID uuid() {
                    return this.uuid;
                }

                public void run() {
                    while (this.threadsWorking$1.containsValue(BoxesRunTime.boxToBoolean((boolean)true))) {
                        Boolean bl;
                        Option option = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply($this.toProcess$1.pollFirst(50L, TimeUnit.MILLISECONDS))).toOption().flatten(Predef$.MODULE$.$conforms());
                        if (None$.MODULE$.equals(option)) {
                            bl = this.threadsWorking$1.put(this.uuid(), BoxesRunTime.boxToBoolean((boolean)false));
                            continue;
                        }
                        if (option instanceof Some) {
                            Boolean bl2;
                            Some some = (Some)option;
                            Tuple2 p = (Tuple2)some.value();
                            FileListUtils$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Thread [").append(this.uuid()).append("] searching [").append(p._1()).append("], waiting to process depth [").append($this.toProcess$1.size()).append("]").toString());
                            this.threadsWorking$1.put(this.uuid(), BoxesRunTime.boxToBoolean((boolean)true));
                            try {
                                FileListUtils$.MODULE$.com$coxautodata$utils$FileListUtils$$ScalaRemoteIterator(this.localFS().listLocatedStatus((Path)p._1())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                                    BoxedUnit boxedUnit;
                                    LocatedFileStatus locatedFileStatus = x0$1;
                                    if (locatedFileStatus.isSymlink()) {
                                        throw new RuntimeException(new StringBuilder(24).append("Link [").append(locatedFileStatus).append("] is not supported").toString());
                                    }
                                    if (locatedFileStatus.isDirectory()) {
                                        Object object;
                                        if (!$this.filterNot$1.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Com_coxautodata_utils_FileListUtils$FileLister$1.$anonfun$run$4(locatedFileStatus, x$2)))) {
                                            SerializableFileStatus s = SerializableFileStatus$.MODULE$.apply((FileStatus)locatedFileStatus);
                                            $this.toProcess$1.addFirst(new Tuple2((Object)locatedFileStatus.getPath(), ((SeqLike)p._2()).$colon$plus((Object)s, Seq$.MODULE$.canBuildFrom())));
                                            object = BoxesRunTime.boxToBoolean((boolean)$this.processed$1.add(new Tuple2((Object)s, p._2())));
                                        } else {
                                            object = BoxedUnit.UNIT;
                                        }
                                        boxedUnit = object;
                                    } else {
                                        boxedUnit = !$this.filterNot$1.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Com_coxautodata_utils_FileListUtils$FileLister$1.$anonfun$run$5(locatedFileStatus, x$3))) ? BoxesRunTime.boxToBoolean((boolean)$this.processed$1.add(new Tuple2((Object)SerializableFileStatus$.MODULE$.apply((FileStatus)locatedFileStatus), p._2()))) : BoxedUnit.UNIT;
                                    }
                                    return boxedUnit;
                                });
                                bl2 = BoxedUnit.UNIT;
                            }
                            catch (Exception e) {
                                bl2 = BoxesRunTime.boxToBoolean((boolean)this.exceptions$1.add(e));
                            }
                            bl = bl2;
                            continue;
                        }
                        throw new MatchError((Object)option);
                    }
                }

                public static final /* synthetic */ boolean $anonfun$run$4(LocatedFileStatus x1$1, Regex x$2) {
                    return x$2.findFirstIn((CharSequence)x1$1.getPath().toString()).isDefined();
                }

                public static final /* synthetic */ boolean $anonfun$run$5(LocatedFileStatus x1$1, Regex x$3) {
                    return x$3.findFirstIn((CharSequence)x1$1.getPath().toString()).isDefined();
                }

                public Com_coxautodata_utils_FileListUtils$FileLister$1(ConcurrentHashMap threadsWorking$1, FileSystem fs$1, LinkedBlockingDeque toProcess$1, List filterNot$1, LinkedBlockingQueue processed$1, ConcurrentLinkedQueue exceptions$1) {
                    this.threadsWorking$1 = threadsWorking$1;
                    this.toProcess$1 = toProcess$1;
                    this.filterNot$1 = filterNot$1;
                    this.processed$1 = processed$1;
                    this.exceptions$1 = exceptions$1;
                    this.localFS = FileSystem.get((URI)fs$1.getUri(), (Configuration)fs$1.getConf());
                    this.uuid = UUID.randomUUID();
                    threadsWorking$1.put(this.uuid(), BoxesRunTime.boxToBoolean((boolean)true));
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(com.coxautodata.utils.FileListUtils$FileLister$1 ), $anonfun$run$2(com.coxautodata.utils.FileListUtils$FileLister$1 scala.Tuple2 ), $anonfun$run$3(com.coxautodata.utils.FileListUtils$FileLister$1 scala.Tuple2 org.apache.hadoop.fs.LocatedFileStatus ), $anonfun$run$4$adapted(org.apache.hadoop.fs.LocatedFileStatus scala.util.matching.Regex ), $anonfun$run$5$adapted(org.apache.hadoop.fs.LocatedFileStatus scala.util.matching.Regex )}, serializedLambda);
                }
            }
            return new Com_coxautodata_utils_FileListUtils$FileLister$1(threadsWorking, fs, toProcess, filterNot, processed, exceptions);
        })).map((Function1 & Serializable & scala.Serializable)x$1 -> pool.submit((Runnable)x$1), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)j -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> j.get(), (ExecutionContext)ExecutionContext$.MODULE$.global()), List$.MODULE$.canBuildFrom());
        Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((TraversableOnce)tasks, Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Duration$.MODULE$.Inf());
        pool.shutdown();
        if (!toProcess.isEmpty()) {
            throw new RuntimeException("Exception listing files, toProcess queue was not empty");
        }
        if (!exceptions.isEmpty()) {
            List collectedExceptions = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(exceptions.iterator()).asScala()).toList();
            collectedExceptions.foreach((Function1 & Serializable & scala.Serializable)e -> {
                FileListUtils$.MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception during file listing", e);
                return BoxedUnit.UNIT;
            });
            throw (Throwable)collectedExceptions.head();
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Finished recursive list of [").append(path).append("]").toString());
        return ((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(processed.iterator()).asScala()).toSeq();
    }

    public RDD<Tuple2<URI, CopyDefinitionWithDependencies>> getSourceFiles(SparkContext sparkContext, Seq<URI> sourceURIs, URI destinationURI, boolean updateOverwritePathBehaviour, int numListstatusThreads, List<Regex> filterNot) {
        RDD sourceRDD = ((RDD)((TraversableOnce)sourceURIs.map((Function1 & Serializable & scala.Serializable)sourceURI -> {
            FileSystem sourceFS = new Path(sourceURI).getFileSystem(sparkContext.hadoopConfiguration());
            return sparkContext.parallelize(MODULE$.listFiles(sourceFS, new Path(sourceURI), numListstatusThreads, !updateOverwritePathBehaviour, filterNot), sparkContext.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                SerializableFileStatus f = (SerializableFileStatus)tuple2._1();
                Seq d = (Seq)tuple2._2();
                Seq dependentFolders = (Seq)d.map((Function1 & Serializable & scala.Serializable)dl -> {
                    URI udl = PathUtils$.MODULE$.sourceURIToDestinationURI(dl.uri(), (URI)sourceURI, destinationURI, updateOverwritePathBehaviour);
                    return new SingleCopyDefinition((SerializableFileStatus)dl, udl);
                }, Seq$.MODULE$.canBuildFrom());
                URI fu = PathUtils$.MODULE$.sourceURIToDestinationURI(f.uri(), (URI)sourceURI, destinationURI, updateOverwritePathBehaviour);
                CopyDefinitionWithDependencies copyDefinitionWithDependencies = new CopyDefinitionWithDependencies(f, fu, (Seq<SingleCopyDefinition>)dependentFolders);
                return copyDefinitionWithDependencies;
            }, ClassTag$.MODULE$.apply(CopyDefinitionWithDependencies.class));
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> x$4.union(x$5))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toKeyedDefinition(), ClassTag$.MODULE$.apply(Tuple2.class));
        this.handleSourceCollisions((RDD<Tuple2<URI, CopyDefinitionWithDependencies>>)sourceRDD);
        this.handleDestCollisions((RDD<Tuple2<URI, CopyDefinitionWithDependencies>>)sourceRDD);
        return sourceRDD;
    }

    public RDD<Tuple2<URI, SerializableFileStatus>> getDestinationFiles(SparkContext sparkContext, Path destinationPath, SparkDistCPOptions options) {
        FileSystem destinationFS = destinationPath.getFileSystem(sparkContext.hadoopConfiguration());
        return sparkContext.parallelize(this.listFiles(destinationFS, destinationPath, options.numListstatusThreads(), false, (List<Regex>)List$.MODULE$.empty()), sparkContext.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SerializableFileStatus f = (SerializableFileStatus)tuple2._1();
            Tuple2 tuple22 = new Tuple2((Object)f.getPath().toUri(), (Object)f);
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public void handleSourceCollisions(RDD<Tuple2<URI, CopyDefinitionWithDependencies>> source) {
        RDD collisions = RDD$.MODULE$.rddToPairRDDFunctions(source, ClassTag$.MODULE$.apply(URI.class), ClassTag$.MODULE$.apply(CopyDefinitionWithDependencies.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).groupByKey().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)FileListUtils$.$anonfun$handleSourceCollisions$1(x$7)));
        collisions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FileListUtils$.$anonfun$handleSourceCollisions$2(x0$1);
            return BoxedUnit.UNIT;
        });
        if (!collisions.isEmpty()) {
            throw new RuntimeException("Collisions found where multiple source files lead to the same destination location; check executor logs for specific collision detail.");
        }
    }

    public void handleDestCollisions(RDD<Tuple2<URI, CopyDefinitionWithDependencies>> source) {
        RDD collisions = source.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<URI, CopyDefinitionWithDependencies>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                CopyDefinitionWithDependencies copyDefinitionWithDependencies;
                A1 A1 = x1;
                if (A1 != null && (copyDefinitionWithDependencies = (CopyDefinitionWithDependencies)A1._2()) != null) {
                    SerializableFileStatus s = copyDefinitionWithDependencies.source();
                    URI d = copyDefinitionWithDependencies.destination();
                    URI uRI = s.uri();
                    URI uRI2 = d;
                    if (!(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null)) {
                        object = d;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<URI, CopyDefinitionWithDependencies> x1) {
                Tuple2<URI, CopyDefinitionWithDependencies> tuple2 = x1;
                if (tuple2 == null) return false;
                CopyDefinitionWithDependencies copyDefinitionWithDependencies = (CopyDefinitionWithDependencies)tuple2._2();
                if (copyDefinitionWithDependencies == null) return false;
                SerializableFileStatus s = copyDefinitionWithDependencies.source();
                URI d = copyDefinitionWithDependencies.destination();
                URI uRI = s.uri();
                URI uRI2 = d;
                if (uRI != null) {
                    if (!((Object)uRI).equals(uRI2)) return false;
                    return true;
                }
                if (uRI2 == null) return true;
                return false;
            }
        }, ClassTag$.MODULE$.apply(URI.class));
        collisions.foreach((Function1 & Serializable & scala.Serializable)d -> {
            FileListUtils$.MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("The following file has the same source and destination location: [").append(d).append("]").toString());
            return BoxedUnit.UNIT;
        });
        if (!collisions.isEmpty()) {
            throw new RuntimeException("Collisions found where a file has the same source and destination location; check executor logs for specific collision detail.");
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleSourceCollisions$1(Tuple2 x$7) {
        return ((TraversableOnce)x$7._2()).size() > 1;
    }

    public static final /* synthetic */ void $anonfun$handleSourceCollisions$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        URI f = (URI)tuple2._1();
        Iterable l = (Iterable)tuple2._2();
        MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("The following files will collide on destination file [").append(f).append("]: ").append(((TraversableOnce)l.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.source().getPath(), Iterable$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private FileListUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

