package com.coxautodev.java.graphql.client.tests.queries;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ResponseFieldMarshaller;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ResponseWriter;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nonnull;

@Generated("Apollo GraphQL")
public final class GetBooksQuery implements Query<GetBooksQuery.Data, Optional<GetBooksQuery.Data>, Operation.Variables> {
  public static final String OPERATION_DEFINITION = "query GetBooks {\n"
      + "  books {\n"
      + "    title\n"
      + "    author {\n"
      + "      name\n"
      + "    }\n"
      + "  }\n"
      + "}";

  public static final String QUERY_DOCUMENT = OPERATION_DEFINITION;

  private static final OperationName OPERATION_NAME = new OperationName() {
    @Override
    public String name() {
      return "GetBooks";
    }
  };

  private final Operation.Variables variables;

  public GetBooksQuery() {
    this.variables = Operation.EMPTY_VARIABLES;
  }

  @Override
  public String operationId() {
    return "92b07faf72b5409853920187051f3f0f5eabacd53a94bdafb187b240d8d56da1";
  }

  @Override
  public String queryDocument() {
    return QUERY_DOCUMENT;
  }

  @Override
  public Optional<GetBooksQuery.Data> wrapData(GetBooksQuery.Data data) {
    return Optional.ofNullable(data);
  }

  @Override
  public Operation.Variables variables() {
    return variables;
  }

  @Override
  public ResponseFieldMapper<GetBooksQuery.Data> responseFieldMapper() {
    return new Data.Mapper();
  }

  public static Builder builder() {
    return new Builder();
  }

  @Override
  public OperationName name() {
    return OPERATION_NAME;
  }

  public static final class Builder {
    Builder() {
    }

    public GetBooksQuery build() {
      return new GetBooksQuery();
    }
  }

  public static class Data implements Operation.Data {
    static final ResponseField[] $responseFields = {
      ResponseField.forObjectList("books", "books", null, false)
    };

    final @Nonnull List<Book> books;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Data(@Nonnull List<Book> books) {
      if (books == null) {
        throw new NullPointerException("books can't be null");
      }
      this.books = books;
    }

    public @Nonnull List<Book> books() {
      return this.books;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeList($responseFields[0], new ResponseWriter.ListWriter() {
            @Override
            public void write(ResponseWriter.ListItemWriter listItemWriter) {
              for (Book $item : books) {
                listItemWriter.writeObject($item.marshaller());
              }
            }
          });
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Data{"
          + "books=" + books
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Data) {
        Data that = (Data) o;
        return this.books.equals(that.books);
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= books.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public static final class Mapper implements ResponseFieldMapper<Data> {
      final Book.Mapper bookFieldMapper = new Book.Mapper();

      @Override
      public Data map(ResponseReader reader) {
        final List<Book> books = reader.readList($responseFields[0], new ResponseReader.ListReader<Book>() {
          @Override
          public Book read(ResponseReader.ListItemReader reader) {
            return reader.readObject(new ResponseReader.ObjectReader<Book>() {
              @Override
              public Book read(ResponseReader reader) {
                return bookFieldMapper.map(reader);
              }
            });
          }
        });
        return new Data(books);
      }
    }
  }

  public static class Book {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("title", "title", null, false),
      ResponseField.forObject("author", "author", null, false)
    };

    final @Nonnull String title;

    final @Nonnull Author author;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Book(@Nonnull String title, @Nonnull Author author) {
      if (title == null) {
        throw new NullPointerException("title can't be null");
      }
      this.title = title;
      if (author == null) {
        throw new NullPointerException("author can't be null");
      }
      this.author = author;
    }

    public @Nonnull String title() {
      return this.title;
    }

    public @Nonnull Author author() {
      return this.author;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], title);
          writer.writeObject($responseFields[1], author.marshaller());
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Book{"
          + "title=" + title + ", "
          + "author=" + author
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Book) {
        Book that = (Book) o;
        return this.title.equals(that.title)
         && this.author.equals(that.author);
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= title.hashCode();
        h *= 1000003;
        h ^= author.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public static final class Mapper implements ResponseFieldMapper<Book> {
      final Author.Mapper authorFieldMapper = new Author.Mapper();

      @Override
      public Book map(ResponseReader reader) {
        final String title = reader.readString($responseFields[0]);
        final Author author = reader.readObject($responseFields[1], new ResponseReader.ObjectReader<Author>() {
          @Override
          public Author read(ResponseReader reader) {
            return authorFieldMapper.map(reader);
          }
        });
        return new Book(title, author);
      }
    }
  }

  public static class Author {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("name", "name", null, false)
    };

    final @Nonnull String name;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Author(@Nonnull String name) {
      if (name == null) {
        throw new NullPointerException("name can't be null");
      }
      this.name = name;
    }

    public @Nonnull String name() {
      return this.name;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], name);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Author{"
          + "name=" + name
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Author) {
        Author that = (Author) o;
        return this.name.equals(that.name);
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= name.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public static final class Mapper implements ResponseFieldMapper<Author> {
      @Override
      public Author map(ResponseReader reader) {
        final String name = reader.readString($responseFields[0]);
        return new Author(name);
      }
    }
  }
}
