package com.coxautodev.java.graphql.client.tests.queries.author;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ResponseFieldMarshaller;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ResponseWriter;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nonnull;

@Generated("Apollo GraphQL")
public final class GetAuthorsQuery implements Query<GetAuthorsQuery.Data, Optional<GetAuthorsQuery.Data>, Operation.Variables> {
  public static final String OPERATION_DEFINITION = "query GetAuthors {\n"
      + "  authors {\n"
      + "    name\n"
      + "  }\n"
      + "}";

  public static final String QUERY_DOCUMENT = OPERATION_DEFINITION;

  private static final OperationName OPERATION_NAME = new OperationName() {
    @Override
    public String name() {
      return "GetAuthors";
    }
  };

  private final Operation.Variables variables;

  public GetAuthorsQuery() {
    this.variables = Operation.EMPTY_VARIABLES;
  }

  @Override
  public String operationId() {
    return "2a56d3fd31295df7e5e98f90f6917884858f78462e0c6e5768b6f2428a5c6d90";
  }

  @Override
  public String queryDocument() {
    return QUERY_DOCUMENT;
  }

  @Override
  public Optional<GetAuthorsQuery.Data> wrapData(GetAuthorsQuery.Data data) {
    return Optional.ofNullable(data);
  }

  @Override
  public Operation.Variables variables() {
    return variables;
  }

  @Override
  public ResponseFieldMapper<GetAuthorsQuery.Data> responseFieldMapper() {
    return new Data.Mapper();
  }

  public static Builder builder() {
    return new Builder();
  }

  @Override
  public OperationName name() {
    return OPERATION_NAME;
  }

  public static final class Builder {
    Builder() {
    }

    public GetAuthorsQuery build() {
      return new GetAuthorsQuery();
    }
  }

  public static class Data implements Operation.Data {
    static final ResponseField[] $responseFields = {
      ResponseField.forObjectList("authors", "authors", null, false)
    };

    final @Nonnull List<Author> authors;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Data(@Nonnull List<Author> authors) {
      if (authors == null) {
        throw new NullPointerException("authors can't be null");
      }
      this.authors = authors;
    }

    public @Nonnull List<Author> authors() {
      return this.authors;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeList($responseFields[0], new ResponseWriter.ListWriter() {
            @Override
            public void write(ResponseWriter.ListItemWriter listItemWriter) {
              for (Author $item : authors) {
                listItemWriter.writeObject($item.marshaller());
              }
            }
          });
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Data{"
          + "authors=" + authors
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Data) {
        Data that = (Data) o;
        return this.authors.equals(that.authors);
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= authors.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public static final class Mapper implements ResponseFieldMapper<Data> {
      final Author.Mapper authorFieldMapper = new Author.Mapper();

      @Override
      public Data map(ResponseReader reader) {
        final List<Author> authors = reader.readList($responseFields[0], new ResponseReader.ListReader<Author>() {
          @Override
          public Author read(ResponseReader.ListItemReader reader) {
            return reader.readObject(new ResponseReader.ObjectReader<Author>() {
              @Override
              public Author read(ResponseReader reader) {
                return authorFieldMapper.map(reader);
              }
            });
          }
        });
        return new Data(authors);
      }
    }
  }

  public static class Author {
    static final ResponseField[] $responseFields = {
      ResponseField.forString("name", "name", null, false)
    };

    final @Nonnull String name;

    private volatile String $toString;

    private volatile int $hashCode;

    private volatile boolean $hashCodeMemoized;

    public Author(@Nonnull String name) {
      if (name == null) {
        throw new NullPointerException("name can't be null");
      }
      this.name = name;
    }

    public @Nonnull String name() {
      return this.name;
    }

    public ResponseFieldMarshaller marshaller() {
      return new ResponseFieldMarshaller() {
        @Override
        public void marshal(ResponseWriter writer) {
          writer.writeString($responseFields[0], name);
        }
      };
    }

    @Override
    public String toString() {
      if ($toString == null) {
        $toString = "Author{"
          + "name=" + name
          + "}";
      }
      return $toString;
    }

    @Override
    public boolean equals(Object o) {
      if (o == this) {
        return true;
      }
      if (o instanceof Author) {
        Author that = (Author) o;
        return this.name.equals(that.name);
      }
      return false;
    }

    @Override
    public int hashCode() {
      if (!$hashCodeMemoized) {
        int h = 1;
        h *= 1000003;
        h ^= name.hashCode();
        $hashCode = h;
        $hashCodeMemoized = true;
      }
      return $hashCode;
    }

    public static final class Mapper implements ResponseFieldMapper<Author> {
      @Override
      public Author map(ResponseReader reader) {
        final String name = reader.readString($responseFields[0]);
        return new Author(name);
      }
    }
  }
}
