/*
 * Decompiled with CFR 0.152.
 */
package com.coxautodev.java.graphql.client.tests.queries;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.OperationName;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.ResponseField;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ResponseFieldMarshaller;
import com.apollographql.apollo.api.ResponseReader;
import com.apollographql.apollo.api.ResponseWriter;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class GetBooksQuery
implements Query<Data, Optional<Data>, Operation.Variables> {
    public static final String OPERATION_DEFINITION = "query GetBooks {\n  books {\n    title\n    author {\n      name\n    }\n  }\n}";
    public static final String QUERY_DOCUMENT = "query GetBooks {\n  books {\n    title\n    author {\n      name\n    }\n  }\n}";
    private static final OperationName OPERATION_NAME = new OperationName(){

        public String name() {
            return "GetBooks";
        }
    };
    private final Operation.Variables variables = Operation.EMPTY_VARIABLES;

    public String operationId() {
        return "92b07faf72b5409853920187051f3f0f5eabacd53a94bdafb187b240d8d56da1";
    }

    public String queryDocument() {
        return "query GetBooks {\n  books {\n    title\n    author {\n      name\n    }\n  }\n}";
    }

    public Optional<Data> wrapData(Data data) {
        return Optional.ofNullable(data);
    }

    public Operation.Variables variables() {
        return this.variables;
    }

    public ResponseFieldMapper<Data> responseFieldMapper() {
        return new Data.Mapper();
    }

    public static Builder builder() {
        return new Builder();
    }

    public OperationName name() {
        return OPERATION_NAME;
    }

    public static class Author {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"name", (String)"name", null, (boolean)false)};
        @Nonnull
        final String name;
        private volatile String $toString;
        private volatile int $hashCode;
        private volatile boolean $hashCodeMemoized;

        public Author(@Nonnull String name) {
            if (name == null) {
                throw new NullPointerException("name can't be null");
            }
            this.name = name;
        }

        @Nonnull
        public String name() {
            return this.name;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], name);
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Author{name=" + this.name + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Author) {
                Author that = (Author)o;
                return this.name.equals(that.name);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.name.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Author> {
            public Author map(ResponseReader reader) {
                String name = reader.readString($responseFields[0]);
                return new Author(name);
            }
        }
    }

    public static class Book {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forString((String)"title", (String)"title", null, (boolean)false), ResponseField.forObject((String)"author", (String)"author", null, (boolean)false)};
        @Nonnull
        final String title;
        @Nonnull
        final Author author;
        private volatile String $toString;
        private volatile int $hashCode;
        private volatile boolean $hashCodeMemoized;

        public Book(@Nonnull String title, @Nonnull Author author) {
            if (title == null) {
                throw new NullPointerException("title can't be null");
            }
            this.title = title;
            if (author == null) {
                throw new NullPointerException("author can't be null");
            }
            this.author = author;
        }

        @Nonnull
        public String title() {
            return this.title;
        }

        @Nonnull
        public Author author() {
            return this.author;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeString($responseFields[0], title);
                    writer.writeObject($responseFields[1], author.marshaller());
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Book{title=" + this.title + ", author=" + this.author + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Book) {
                Book that = (Book)o;
                return this.title.equals(that.title) && this.author.equals(that.author);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                h ^= this.title.hashCode();
                h *= 1000003;
                this.$hashCode = h ^= this.author.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Book> {
            final Author.Mapper authorFieldMapper = new Author.Mapper();

            public Book map(ResponseReader reader) {
                String title = reader.readString($responseFields[0]);
                Author author = (Author)reader.readObject($responseFields[1], (ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Author>(){

                    public Author read(ResponseReader reader) {
                        return authorFieldMapper.map(reader);
                    }
                });
                return new Book(title, author);
            }
        }
    }

    public static class Data
    implements Operation.Data {
        static final ResponseField[] $responseFields = new ResponseField[]{ResponseField.forObjectList((String)"books", (String)"books", null, (boolean)false)};
        @Nonnull
        final List<Book> books;
        private volatile String $toString;
        private volatile int $hashCode;
        private volatile boolean $hashCodeMemoized;

        public Data(@Nonnull List<Book> books) {
            if (books == null) {
                throw new NullPointerException("books can't be null");
            }
            this.books = books;
        }

        @Nonnull
        public List<Book> books() {
            return this.books;
        }

        public ResponseFieldMarshaller marshaller() {
            return new ResponseFieldMarshaller(){

                public void marshal(ResponseWriter writer) {
                    writer.writeList($responseFields[0], new ResponseWriter.ListWriter(){

                        public void write(ResponseWriter.ListItemWriter listItemWriter) {
                            for (Book $item : books) {
                                listItemWriter.writeObject($item.marshaller());
                            }
                        }
                    });
                }
            };
        }

        public String toString() {
            if (this.$toString == null) {
                this.$toString = "Data{books=" + this.books + "}";
            }
            return this.$toString;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Data) {
                Data that = (Data)o;
                return this.books.equals(that.books);
            }
            return false;
        }

        public int hashCode() {
            if (!this.$hashCodeMemoized) {
                int h = 1;
                h *= 1000003;
                this.$hashCode = h ^= this.books.hashCode();
                this.$hashCodeMemoized = true;
            }
            return this.$hashCode;
        }

        public static final class Mapper
        implements ResponseFieldMapper<Data> {
            final Book.Mapper bookFieldMapper = new Book.Mapper();

            public Data map(ResponseReader reader) {
                List books = reader.readList($responseFields[0], (ResponseReader.ListReader)new ResponseReader.ListReader<Book>(){

                    public Book read(ResponseReader.ListItemReader reader) {
                        return (Book)reader.readObject((ResponseReader.ObjectReader)new ResponseReader.ObjectReader<Book>(){

                            public Book read(ResponseReader reader) {
                                return bookFieldMapper.map(reader);
                            }
                        });
                    }
                });
                return new Data(books);
            }
        }
    }

    public static final class Builder {
        Builder() {
        }

        public GetBooksQuery build() {
            return new GetBooksQuery();
        }
    }
}

