/*
 * Decompiled with CFR 0.152.
 */
package com.coze.api.helper;

import android.util.Base64;
import com.coze.api.helper.AndroidPlatform;
import com.coze.api.helper.Platform;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"generateCodeVerifier", "", "generateCodeChallenge", "codeVerifier", "isBrowser", "", "getPlatform", "Lcom/coze/api/helper/Platform;", "cozeAPI_release"})
public final class PlatformKt {
    @NotNull
    public static final String generateCodeVerifier() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] bytes = new byte[32];
        secureRandom.nextBytes(bytes);
        return ArraysKt.joinToString$default((byte[])bytes, (CharSequence)"", null, null, (int)0, null, PlatformKt::generateCodeVerifier$lambda$0, (int)30, null);
    }

    @NotNull
    public static final String generateCodeChallenge(@NotNull String codeVerifier) {
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        String string = codeVerifier;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] digest = messageDigest.digest(bytes);
        String string2 = Base64.encodeToString((byte[])digest, (int)11);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    public static final boolean isBrowser() {
        return false;
    }

    @NotNull
    public static final Platform getPlatform() {
        return new AndroidPlatform();
    }

    private static final CharSequence generateCodeVerifier$lambda$0(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

