/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class UserAgentInterceptor
implements Interceptor {
    public static final String VERSION = "1.0.0";
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request().newBuilder().addHeader("User-Agent", UserAgentInterceptor.getUserAgent()).addHeader("X-Coze-Client-User-Agent", UserAgentInterceptor.getCozeClientUserAgent()).build();
        return chain.proceed(request);
    }

    private static String getOsVersion() {
        String osName = System.getProperty("os.name").toLowerCase();
        String osVersion = osName.contains("mac") ? System.getProperty("os.version") : (osName.contains("windows") ? System.getProperty("os.version") : (osName.contains("linux") ? System.getProperty("os.version") : System.getProperty("os.version")));
        return osVersion;
    }

    private static String getUserAgent() {
        String javaVersion = System.getProperty("java.version").split("\\.")[0];
        String osName = System.getProperty("os.name").toLowerCase();
        String osVersion = UserAgentInterceptor.getOsVersion();
        return String.format("cozejava/%s java/%s %s/%s", VERSION, javaVersion, osName, osVersion).toLowerCase();
    }

    private static String getCozeClientUserAgent() {
        try {
            HashMap<String, String> ua = new HashMap<String, String>();
            ua.put("version", VERSION);
            ua.put("lang", "java");
            ua.put("lang_version", System.getProperty("java.version").split("\\.")[0]);
            ua.put("os_name", System.getProperty("os.name").toLowerCase());
            ua.put("os_version", UserAgentInterceptor.getOsVersion());
            return objectMapper.writeValueAsString(ua);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

