/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.auth;

import com.coze.openapi.client.auth.DeviceAuthReq;
import com.coze.openapi.client.auth.DeviceAuthResp;
import com.coze.openapi.client.auth.GetAccessTokenReq;
import com.coze.openapi.client.auth.GrantType;
import com.coze.openapi.client.auth.OAuthToken;
import com.coze.openapi.client.common.BaseReq;
import com.coze.openapi.client.exception.AuthErrorCode;
import com.coze.openapi.client.exception.CozeAuthException;
import com.coze.openapi.service.auth.AuthLogFactory;
import com.coze.openapi.service.auth.OAuthClient;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class DeviceOAuthClient
extends OAuthClient {
    private static final Logger logger = AuthLogFactory.getLogger();

    protected DeviceOAuthClient(DeviceOAuthBuilder builder) {
        super(builder);
    }

    public DeviceAuthResp getDeviceCode() {
        BaseReq req = ((DeviceAuthReq.DeviceAuthReqBuilder)DeviceAuthReq.builder().clientID(this.clientID)).build();
        DeviceAuthResp resp = DeviceOAuthClient.execute(this.api.device((DeviceAuthReq)req));
        resp.setVerificationURL(resp.getVerificationURI() + "?user_code=" + resp.getUserCode());
        return resp;
    }

    public DeviceAuthResp getDeviceCode(@NotNull String workspaceID) {
        BaseReq req = ((DeviceAuthReq.DeviceAuthReqBuilder)DeviceAuthReq.builder().clientID(this.clientID)).build();
        DeviceAuthResp resp = DeviceOAuthClient.execute(this.api.device(workspaceID, (DeviceAuthReq)req));
        resp.setVerificationURL(resp.getVerificationURI() + "?user_code=" + resp.getUserCode());
        return resp;
    }

    public OAuthToken getAccessToken(String deviceCode) throws Exception {
        return this.getAccessToken(deviceCode, false);
    }

    /*
     * Loose catch block
     */
    public OAuthToken getAccessToken(String deviceCode, boolean poll) throws Exception {
        GetAccessTokenReq.GetAccessTokenReqBuilder<?, ?> builder = GetAccessTokenReq.builder();
        ((GetAccessTokenReq.GetAccessTokenReqBuilder)((GetAccessTokenReq.GetAccessTokenReqBuilder)builder.clientID(this.clientID)).grantType(GrantType.DEVICE_CODE.getValue())).deviceCode(deviceCode);
        if (!poll) {
            return super.getAccessToken(null, (GetAccessTokenReq)builder.build());
        }
        int interval = 5;
        while (true) {
            try {
                return super.getAccessToken(null, (GetAccessTokenReq)builder.build());
            }
            catch (CozeAuthException e) {
                if (AuthErrorCode.AUTHORIZATION_PENDING.equals(e.getCode())) {
                    logger.info("Authorization pending, sleep " + interval + " seconds");
                } else if (AuthErrorCode.SLOW_DOWN.equals(e.getCode())) {
                    if (interval < 30) {
                        interval += 5;
                    }
                    logger.info("Slow down, sleep " + interval + " seconds");
                } else {
                    throw e;
                }
                try {
                    TimeUnit.SECONDS.sleep(interval);
                }
                catch (InterruptedException ie) {
                    logger.warn("Interrupted while sleeping", (Throwable)ie);
                    Thread.currentThread().interrupt();
                    throw ie;
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
    }

    @Override
    public OAuthToken refreshToken(String refreshToken) {
        return super.refreshAccessToken(refreshToken, this.clientSecret);
    }

    public static class DeviceOAuthBuilder
    extends OAuthClient.OAuthBuilder<DeviceOAuthBuilder> {
        @Override
        protected DeviceOAuthBuilder self() {
            return this;
        }

        @Override
        public DeviceOAuthClient build() {
            return new DeviceOAuthClient(this);
        }
    }
}

