/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class ChromaticAberrationEffect
extends ShaderVfxEffect
implements ChainVfxEffect {
    private static final String U_TEXTURE0 = "u_texture0";
    private static final String U_MAX_DISTORTION = "u_maxDistortion";
    private float maxDistortion = 1.2f;

    public ChromaticAberrationEffect(int passes) {
        super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/screenspace.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/chromatic-aberration.frag"), (String)("#define PASSES " + passes)));
        this.rebind();
    }

    public void rebind() {
        super.rebind();
        this.program.begin();
        this.program.setUniformi(U_TEXTURE0, 0);
        this.program.setUniformf(U_MAX_DISTORTION, this.maxDistortion);
        this.program.end();
    }

    public float getMaxDistortion() {
        return this.maxDistortion;
    }

    public void setMaxDistortion(float maxDistortion) {
        this.maxDistortion = maxDistortion;
        this.setUniform(U_MAX_DISTORTION, maxDistortion);
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        this.render(context, buffers.getSrcBuffer(), buffers.getDstBuffer());
    }

    public void render(VfxRenderContext context, VfxFrameBuffer src, VfxFrameBuffer dst) {
        src.getTexture().bind(0);
        this.renderShader(context, dst);
    }
}

