/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.Vector2;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class FxaaEffect
extends ShaderVfxEffect
implements ChainVfxEffect {
    private static final String U_TEXTURE0 = "u_texture0";
    private static final String U_VIEWPORT_INVERSE = "u_viewportInverse";
    private static final String U_FXAA_REDUCE_MIN = "u_fxaaReduceMin";
    private static final String U_FXAA_REDUCE_MUL = "u_fxaaReduceMul";
    private static final String U_FXAA_SPAN_MAX = "u_fxaaSpanMax";
    private final Vector2 viewportInverse = new Vector2();
    private float fxaaReduceMin;
    private float fxaaReduceMul;
    private float fxaaSpanMax;

    public FxaaEffect() {
        this(0.0078125f, 0.125f, 8.0f, true);
    }

    public FxaaEffect(float fxaaReduceMin, float fxaaReduceMul, float fxaaSpanMax, boolean supportAlpha) {
        super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/screenspace.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/fxaa.frag"), (String)(supportAlpha ? "#define SUPPORT_ALPHA" : "")));
        this.fxaaReduceMin = fxaaReduceMin;
        this.fxaaReduceMul = fxaaReduceMul;
        this.fxaaSpanMax = fxaaSpanMax;
        this.rebind();
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        this.viewportInverse.set(1.0f / (float)width, 1.0f / (float)height);
        this.setUniform(U_VIEWPORT_INVERSE, this.viewportInverse);
    }

    public void rebind() {
        super.rebind();
        this.program.begin();
        this.program.setUniformi(U_TEXTURE0, 0);
        this.program.setUniformf(U_VIEWPORT_INVERSE, this.viewportInverse);
        this.program.setUniformf(U_FXAA_REDUCE_MIN, this.fxaaReduceMin);
        this.program.setUniformf(U_FXAA_REDUCE_MUL, this.fxaaReduceMul);
        this.program.setUniformf(U_FXAA_SPAN_MAX, this.fxaaSpanMax);
        this.program.end();
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        this.render(context, buffers.getSrcBuffer(), buffers.getDstBuffer());
    }

    public void render(VfxRenderContext context, VfxFrameBuffer src, VfxFrameBuffer dst) {
        src.getTexture().bind(0);
        this.renderShader(context, dst);
    }

    public void setReduceMin(float value) {
        this.fxaaReduceMin = value;
        this.setUniform(U_FXAA_REDUCE_MIN, this.fxaaReduceMin);
    }

    public void setReduceMul(float value) {
        this.fxaaReduceMul = value;
        this.setUniform(U_FXAA_REDUCE_MUL, this.fxaaReduceMul);
    }

    public void setSpanMax(float value) {
        this.fxaaSpanMax = value;
        this.setUniform(U_FXAA_SPAN_MAX, this.fxaaSpanMax);
    }
}

