/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.AbstractVfxEffect;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.CompositeVfxEffect;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.effects.VfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class GaussianBlurEffect
extends AbstractVfxEffect
implements ChainVfxEffect {
    private BlurType type;
    private float amount = 1.0f;
    private int passes = 1;
    private float invWidth;
    private float invHeight;
    private Convolve2DEffect convolve;

    public GaussianBlurEffect() {
        this(BlurType.Gaussian5x5);
    }

    public GaussianBlurEffect(BlurType blurType) {
        this.setType(blurType);
    }

    public void dispose() {
        this.convolve.dispose();
    }

    public void resize(int width, int height) {
        this.invWidth = 1.0f / (float)width;
        this.invHeight = 1.0f / (float)height;
        this.convolve.resize(width, height);
        this.computeBlurWeightings();
    }

    public void rebind() {
        this.convolve.rebind();
        this.computeBlurWeightings();
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        for (int i = 0; i < this.passes; ++i) {
            this.convolve.render(context, buffers);
            if (i >= this.passes - 1) continue;
            buffers.swap();
        }
    }

    public void update(float delta) {
    }

    public BlurType getType() {
        return this.type;
    }

    public void setType(BlurType type) {
        if (type == null) {
            throw new IllegalArgumentException("Blur type cannot be null.");
        }
        if (this.type != type) {
            this.type = type;
            if (this.convolve != null) {
                this.convolve.dispose();
            }
            this.convolve = new Convolve2DEffect(this.type.tap.radius);
            this.computeBlurWeightings();
        }
    }

    public float getAmount() {
        return this.amount;
    }

    public void setAmount(float amount) {
        this.amount = amount;
        this.computeBlurWeightings();
    }

    public int getPasses() {
        return this.passes;
    }

    public void setPasses(int passes) {
        if (passes < 1) {
            throw new IllegalArgumentException("Passes should be greater than 0.");
        }
        this.passes = passes;
    }

    private void computeBlurWeightings() {
        boolean hasData = true;
        float[] outWeights = this.convolve.getWeights();
        float[] outOffsetsH = this.convolve.getOffsetsHor();
        float[] outOffsetsV = this.convolve.getOffsetsVert();
        float dx = this.invWidth;
        float dy = this.invHeight;
        switch (this.type) {
            case Gaussian3x3: 
            case Gaussian5x5: {
                this.computeKernel(this.type.tap.radius, this.amount, outWeights);
                this.computeOffsets(this.type.tap.radius, this.invWidth, this.invHeight, outOffsetsH, outOffsetsV);
                break;
            }
            case Gaussian3x3b: {
                outWeights[0] = 0.352941f;
                outWeights[1] = 0.294118f;
                outWeights[2] = 0.352941f;
                outOffsetsH[0] = -1.33333f;
                outOffsetsH[1] = 0.0f;
                outOffsetsH[2] = 0.0f;
                outOffsetsH[3] = 0.0f;
                outOffsetsH[4] = 1.33333f;
                outOffsetsH[5] = 0.0f;
                outOffsetsV[0] = 0.0f;
                outOffsetsV[1] = -1.33333f;
                outOffsetsV[2] = 0.0f;
                outOffsetsV[3] = 0.0f;
                outOffsetsV[4] = 0.0f;
                outOffsetsV[5] = 1.33333f;
                int i = 0;
                while (i < this.convolve.getLength() * 2) {
                    int n = i;
                    outOffsetsH[n] = outOffsetsH[n] * dx;
                    int n2 = i++;
                    outOffsetsV[n2] = outOffsetsV[n2] * dy;
                }
                break;
            }
            case Gaussian5x5b: {
                outWeights[0] = 0.0702703f;
                outWeights[1] = 0.316216f;
                outWeights[2] = 0.227027f;
                outWeights[3] = 0.316216f;
                outWeights[4] = 0.0702703f;
                outOffsetsH[0] = -3.23077f;
                outOffsetsH[1] = 0.0f;
                outOffsetsH[2] = -1.38462f;
                outOffsetsH[3] = 0.0f;
                outOffsetsH[4] = 0.0f;
                outOffsetsH[5] = 0.0f;
                outOffsetsH[6] = 1.38462f;
                outOffsetsH[7] = 0.0f;
                outOffsetsH[8] = 3.23077f;
                outOffsetsH[9] = 0.0f;
                outOffsetsV[0] = 0.0f;
                outOffsetsV[1] = -3.23077f;
                outOffsetsV[2] = 0.0f;
                outOffsetsV[3] = -1.38462f;
                outOffsetsV[4] = 0.0f;
                outOffsetsV[5] = 0.0f;
                outOffsetsV[6] = 0.0f;
                outOffsetsV[7] = 1.38462f;
                outOffsetsV[8] = 0.0f;
                outOffsetsV[9] = 3.23077f;
                int i = 0;
                while (i < this.convolve.getLength() * 2) {
                    int n = i;
                    outOffsetsH[n] = outOffsetsH[n] * dx;
                    int n3 = i++;
                    outOffsetsV[n3] = outOffsetsV[n3] * dy;
                }
                break;
            }
            default: {
                hasData = false;
            }
        }
        if (hasData) {
            this.convolve.rebind();
        }
    }

    private void computeKernel(int blurRadius, float blurAmount, float[] outKernel) {
        int radius = blurRadius;
        float sigma = blurAmount;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        float distance = 0.0f;
        int index = 0;
        for (int i = -radius; i <= radius; ++i) {
            distance = i * i;
            index = i + radius;
            outKernel[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += outKernel[index];
        }
        int size = radius * 2 + 1;
        int i = 0;
        while (i < size) {
            int n = i++;
            outKernel[n] = outKernel[n] / total;
        }
    }

    private void computeOffsets(int blurRadius, float dx, float dy, float[] outOffsetH, float[] outOffsetV) {
        int radius = blurRadius;
        boolean X = false;
        boolean Y = true;
        int i = -radius;
        int j = 0;
        while (i <= radius) {
            outOffsetH[j + 0] = (float)i * dx;
            outOffsetH[j + 1] = 0.0f;
            outOffsetV[j + 0] = 0.0f;
            outOffsetV[j + 1] = (float)i * dy;
            ++i;
            j += 2;
        }
    }

    public static final class Convolve2DEffect
    extends CompositeVfxEffect
    implements ChainVfxEffect {
        private final int radius;
        private final int length;
        private final float[] weights;
        private final float[] offsetsHor;
        private final float[] offsetsVert;
        private Convolve1DEffect hor;
        private Convolve1DEffect vert;

        public Convolve2DEffect(int radius) {
            this.radius = radius;
            this.length = radius * 2 + 1;
            this.hor = (Convolve1DEffect)this.register((VfxEffect)new Convolve1DEffect(this.length));
            this.vert = (Convolve1DEffect)this.register((VfxEffect)new Convolve1DEffect(this.length, this.hor.weights));
            this.weights = this.hor.weights;
            this.offsetsHor = this.hor.offsets;
            this.offsetsVert = this.vert.offsets;
        }

        public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
            this.hor.render(context, buffers);
            buffers.swap();
            this.vert.render(context, buffers);
        }

        public int getRadius() {
            return this.radius;
        }

        public int getLength() {
            return this.length;
        }

        public float[] getWeights() {
            return this.weights;
        }

        public float[] getOffsetsHor() {
            return this.offsetsHor;
        }

        public float[] getOffsetsVert() {
            return this.offsetsVert;
        }
    }

    public static final class Convolve1DEffect
    extends ShaderVfxEffect
    implements ChainVfxEffect {
        private static final String U_TEXTURE = "u_texture0";
        private static final String U_SAMPLE_WEIGHTS = "u_sampleWeights";
        private static final String U_SAMPLE_OFFSETS = "u_sampleOffsets";
        public int length;
        public float[] weights;
        public float[] offsets;

        public Convolve1DEffect(int length) {
            this(length, new float[length], new float[length * 2]);
        }

        public Convolve1DEffect(int length, float[] weightsData) {
            this(length, weightsData, new float[length * 2]);
        }

        public Convolve1DEffect(int length, float[] weightsData, float[] offsets) {
            super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/screenspace.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/convolve-1d.frag"), (String)("#define LENGTH " + length)));
            this.setWeights(length, weightsData, offsets);
            this.rebind();
        }

        public void rebind() {
            super.rebind();
            this.program.begin();
            this.program.setUniformi(U_TEXTURE, 0);
            this.program.setUniform2fv(U_SAMPLE_OFFSETS, this.offsets, 0, this.length * 2);
            this.program.setUniform1fv(U_SAMPLE_WEIGHTS, this.weights, 0, this.length);
            this.program.end();
        }

        public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
            this.render(context, buffers.getSrcBuffer(), buffers.getDstBuffer());
        }

        public void render(VfxRenderContext context, VfxFrameBuffer src, VfxFrameBuffer dst) {
            src.getTexture().bind(0);
            this.renderShader(context, dst);
        }

        public void setWeights(int length, float[] weights, float[] offsets) {
            this.weights = weights;
            this.length = length;
            this.offsets = offsets;
        }
    }

    public static enum BlurType {
        Gaussian3x3(Tap.Tap3x3),
        Gaussian3x3b(Tap.Tap3x3),
        Gaussian5x5(Tap.Tap5x5),
        Gaussian5x5b(Tap.Tap5x5);

        public final Tap tap;

        private BlurType(Tap tap) {
            this.tap = tap;
        }
    }

    private static enum Tap {
        Tap3x3(1),
        Tap5x5(2);

        public final int radius;

        private Tap(int radius) {
            this.radius = radius;
        }
    }
}

