/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class LensFlareEffect
extends ShaderVfxEffect
implements ChainVfxEffect {
    private static final String U_TEXTURE0 = "u_texture0";
    private static final String U_LIGHT_POSITION = "u_lightPosition";
    private static final String U_INTENSITY = "u_intensity";
    private static final String U_COLOR = "u_color";
    private static final String U_VIEWPORT = "u_viewport";
    private final Vector2 lightPosition = new Vector2(0.5f, 0.5f);
    private final Vector2 viewport = new Vector2();
    private final Vector3 color = new Vector3(1.0f, 0.8f, 0.2f);
    private float intensity = 5.0f;

    public LensFlareEffect() {
        super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/screenspace.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/lens-flare.frag")));
        this.rebind();
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        this.viewport.set((float)width, (float)height);
        this.setUniform(U_VIEWPORT, this.viewport);
    }

    public void rebind() {
        super.rebind();
        this.program.begin();
        this.program.setUniformi(U_TEXTURE0, 0);
        this.program.setUniformf(U_LIGHT_POSITION, this.lightPosition);
        this.program.setUniformf(U_INTENSITY, this.intensity);
        this.program.setUniformf(U_COLOR, this.color);
        this.program.setUniformf(U_VIEWPORT, this.viewport);
        this.program.end();
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        this.render(context, buffers.getSrcBuffer(), buffers.getDstBuffer());
    }

    public void render(VfxRenderContext context, VfxFrameBuffer src, VfxFrameBuffer dst) {
        src.getTexture().bind(0);
        this.renderShader(context, dst);
    }

    public Vector2 getLightPosition() {
        return this.lightPosition;
    }

    public void setLightPosition(Vector2 lightPosition) {
        this.setLightPosition(lightPosition.x, lightPosition.y);
    }

    public void setLightPosition(float x, float y) {
        this.lightPosition.set(x, y);
        this.setUniform(U_LIGHT_POSITION, this.lightPosition);
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
        this.setUniform(U_INTENSITY, intensity);
    }

    public Vector3 getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.setColor(color.r, color.g, color.b);
    }

    public void setColor(float r, float g, float b) {
        this.color.set(r, g, b);
        this.setUniform(U_COLOR, this.color);
    }
}

