/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class LevelsEffect
extends ShaderVfxEffect
implements ChainVfxEffect {
    private static final String Texture = "u_texture0";
    private static final String Brightness = "u_brightness";
    private static final String Contrast = "u_contrast";
    private static final String Saturation = "u_saturation";
    private static final String Hue = "u_hue";
    private static final String Gamma = "u_gamma";
    private float brightness = 0.0f;
    private float contrast = 1.0f;
    private float saturation = 1.0f;
    private float hue = 1.0f;
    private float gamma = 1.0f;

    public LevelsEffect() {
        super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/screenspace.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/levels.frag")));
        this.rebind();
    }

    public void rebind() {
        super.rebind();
        this.program.begin();
        this.program.setUniformi(Texture, 0);
        this.program.setUniformf(Brightness, this.brightness);
        this.program.setUniformf(Contrast, this.contrast);
        this.program.setUniformf(Saturation, this.saturation);
        this.program.setUniformf(Hue, this.hue);
        this.program.setUniformf(Gamma, this.gamma);
        this.program.end();
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        this.render(context, buffers.getSrcBuffer(), buffers.getDstBuffer());
    }

    public void render(VfxRenderContext context, VfxFrameBuffer src, VfxFrameBuffer dst) {
        src.getTexture().bind(0);
        this.renderShader(context, dst);
    }

    public float getContrast() {
        return this.contrast;
    }

    public void setContrast(float contrast) {
        this.contrast = contrast;
        this.setUniform(Contrast, this.contrast);
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
        this.setUniform(Brightness, this.brightness);
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
        this.setUniform(Saturation, this.saturation);
    }

    public float getHue() {
        return this.hue;
    }

    public void setHue(float hue) {
        this.hue = hue;
        this.setUniform(Hue, this.hue);
    }

    public float getGamma() {
        return this.gamma;
    }

    public void setGamma(float gamma) {
        this.gamma = gamma;
        this.setUniform(Gamma, this.gamma);
    }
}

