/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.CompositeVfxEffect;
import com.crashinvaders.vfx.effects.VfxEffect;
import com.crashinvaders.vfx.effects.util.CopyEffect;
import com.crashinvaders.vfx.effects.util.MixEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxFrameBufferQueue;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;

public class MotionBlurEffect
extends CompositeVfxEffect
implements ChainVfxEffect {
    private final MixEffect mixFilter;
    private final CopyEffect copyFilter;
    private final VfxFrameBufferQueue localBuffer;
    private boolean firstFrameRendered = false;

    public MotionBlurEffect(Pixmap.Format pixelFormat, MixEffect.Method mixMethod, float blurFactor) {
        this.mixFilter = (MixEffect)this.register((VfxEffect)new MixEffect(mixMethod));
        this.mixFilter.setMixFactor(blurFactor);
        this.copyFilter = (CopyEffect)this.register((VfxEffect)new CopyEffect());
        this.localBuffer = new VfxFrameBufferQueue(pixelFormat, Gdx.app.getType() == Application.ApplicationType.WebGL ? 2 : 1);
    }

    public void dispose() {
        super.dispose();
        this.localBuffer.dispose();
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        this.localBuffer.resize(width, height);
        this.firstFrameRendered = false;
    }

    public void rebind() {
        super.rebind();
        this.localBuffer.rebind();
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        VfxFrameBuffer prevFrame = this.localBuffer.changeToNext();
        if (!this.firstFrameRendered) {
            this.copyFilter.render(context, buffers.getSrcBuffer(), prevFrame);
            buffers.swap();
            this.firstFrameRendered = true;
            return;
        }
        this.mixFilter.render(context, buffers.getSrcBuffer(), prevFrame, buffers.getDstBuffer());
        this.copyFilter.render(context, buffers.getDstBuffer(), prevFrame);
    }
}

