/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class RadialBlurEffect
extends ShaderVfxEffect
implements ChainVfxEffect {
    private static String U_TEXTURE = "u_texture0";
    private static String U_BLUR_DIV = "u_blurDiv";
    private static String U_OFFSET_X = "u_offsetX";
    private static String U_OFFSET_Y = "u_offsetY";
    private static String U_ZOOM = "u_zoom";
    private final int passes;
    private float strength = 0.2f;
    private float originX = 0.5f;
    private float originY = 0.5f;
    private float zoom = 1.0f;

    public RadialBlurEffect(int passes) {
        super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/radial-blur.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/radial-blur.frag"), (String)("#define PASSES " + passes)));
        this.passes = passes;
        this.rebind();
    }

    public void rebind() {
        super.rebind();
        this.program.begin();
        this.program.setUniformi(U_TEXTURE, 0);
        this.program.setUniformf(U_BLUR_DIV, this.strength / (float)this.passes);
        this.program.setUniformf(U_OFFSET_X, this.originX);
        this.program.setUniformf(U_OFFSET_Y, this.originY);
        this.program.setUniformf(U_ZOOM, this.zoom);
        this.program.end();
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        this.render(context, buffers.getSrcBuffer(), buffers.getDstBuffer());
    }

    public void render(VfxRenderContext context, VfxFrameBuffer src, VfxFrameBuffer dst) {
        src.getTexture().bind(0);
        this.renderShader(context, dst);
    }

    public float getOriginX() {
        return this.originX;
    }

    public float getOriginY() {
        return this.originY;
    }

    public void setOrigin(int align) {
        float originX = (align & 8) != 0 ? 0.0f : ((align & 0x10) != 0 ? 1.0f : 0.5f);
        float originY = (align & 4) != 0 ? 0.0f : ((align & 2) != 0 ? 1.0f : 0.5f);
        this.setOrigin(originX, originY);
    }

    public void setOrigin(float originX, float originY) {
        this.originX = originX;
        this.originY = originY;
        this.program.begin();
        this.program.setUniformf(U_OFFSET_X, this.originX);
        this.program.setUniformf(U_OFFSET_Y, this.originY);
        this.program.end();
    }

    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
        this.setUniform(U_BLUR_DIV, strength / (float)this.passes);
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
        this.setUniform(U_ZOOM, this.zoom);
    }
}

