/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class VignettingEffect
extends ShaderVfxEffect
implements ChainVfxEffect {
    private static final String TEXTURE0 = "u_texture0";
    private static final String VIGNETTE_INTENSITY = "u_vignetteIntensity";
    private static final String VIGNETTE_X = "u_vignetteX";
    private static final String VIGNETTE_Y = "u_vignetteY";
    private static final String CENTER_X = "u_centerX";
    private static final String CENTER_Y = "u_centerY";
    private static final String SATURATION = "u_saturation";
    private static final String SATURATION_MUL = "u_saturationMul";
    private float vignetteX = 0.8f;
    private float vignetteY = 0.25f;
    private float centerX = 0.5f;
    private float centerY = 0.5f;
    private float intensity = 1.0f;
    private final boolean saturationEnabled;
    private float saturation = 0.0f;
    private float saturationMul = 0.0f;

    public VignettingEffect(boolean controlSaturation) {
        super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/screenspace.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/vignetting.frag"), (String)(controlSaturation ? "#define CONTROL_SATURATION" : "")));
        this.saturationEnabled = controlSaturation;
        this.rebind();
    }

    public void rebind() {
        this.program.begin();
        this.program.setUniformi(TEXTURE0, 0);
        if (this.saturationEnabled) {
            this.program.setUniformf(SATURATION, this.saturation);
            this.program.setUniformf(SATURATION_MUL, this.saturationMul);
        }
        this.program.setUniformf(VIGNETTE_INTENSITY, this.intensity);
        this.program.setUniformf(VIGNETTE_X, this.vignetteX);
        this.program.setUniformf(VIGNETTE_Y, this.vignetteY);
        this.program.setUniformf(CENTER_X, this.centerX);
        this.program.setUniformf(CENTER_Y, this.centerY);
        this.program.end();
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        this.render(context, buffers.getSrcBuffer(), buffers.getDstBuffer());
    }

    public void render(VfxRenderContext context, VfxFrameBuffer src, VfxFrameBuffer dst) {
        src.getTexture().bind(0);
        this.renderShader(context, dst);
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
        this.setUniform(VIGNETTE_INTENSITY, intensity);
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
        if (this.saturationEnabled) {
            this.setUniform(SATURATION, saturation);
        }
    }

    public void setSaturationMul(float saturationMul) {
        this.saturationMul = saturationMul;
        if (this.saturationEnabled) {
            this.setUniform(SATURATION_MUL, saturationMul);
        }
    }

    public void setCoords(float x, float y) {
        this.vignetteX = x;
        this.vignetteY = y;
        this.program.begin();
        this.program.setUniformf(VIGNETTE_X, x);
        this.program.setUniformf(VIGNETTE_Y, y);
        this.program.end();
    }

    public void setVignetteX(float x) {
        this.vignetteX = x;
        this.setUniform(VIGNETTE_X, x);
    }

    public void setVignetteY(float vignetteY) {
        this.vignetteY = vignetteY;
        this.setUniform(VIGNETTE_Y, vignetteY);
    }

    public void setCenter(float x, float y) {
        this.centerX = x;
        this.centerY = y;
        this.program.begin();
        this.program.setUniformf(CENTER_X, this.centerX);
        this.program.setUniformf(CENTER_Y, this.centerY);
        this.program.end();
    }

    public float getCenterX() {
        return this.centerX;
    }

    public float getCenterY() {
        return this.centerY;
    }

    public float getVignetteX() {
        return this.vignetteX;
    }

    public float getVignetteY() {
        return this.vignetteY;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public float getSaturationMul() {
        return this.saturationMul;
    }

    public boolean isSaturationControlEnabled() {
        return this.saturationEnabled;
    }
}

