/*
 * Decompiled with CFR 0.152.
 */
package com.crashinvaders.vfx.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.crashinvaders.vfx.VfxRenderContext;
import com.crashinvaders.vfx.effects.ChainVfxEffect;
import com.crashinvaders.vfx.effects.ShaderVfxEffect;
import com.crashinvaders.vfx.framebuffer.VfxFrameBuffer;
import com.crashinvaders.vfx.framebuffer.VfxPingPongWrapper;
import com.crashinvaders.vfx.gl.VfxGLUtils;

public class ZoomEffect
extends ShaderVfxEffect
implements ChainVfxEffect {
    private static final String U_TEXTURE0 = "u_texture0";
    private static final String U_OFFSET_X = "u_offsetX";
    private static final String U_OFFSET_Y = "u_offsetY";
    private static final String U_ZOOM = "u_zoom";
    private float originX = 0.5f;
    private float originY = 0.5f;
    private float zoom = 1.0f;

    public ZoomEffect() {
        super(VfxGLUtils.compileShader((FileHandle)Gdx.files.classpath("gdxvfx/shaders/zoom.vert"), (FileHandle)Gdx.files.classpath("gdxvfx/shaders/zoom.frag")));
        this.rebind();
    }

    public void rebind() {
        super.rebind();
        this.program.begin();
        this.program.setUniformi(U_TEXTURE0, 0);
        this.program.setUniformf(U_OFFSET_X, this.originX);
        this.program.setUniformf(U_OFFSET_Y, this.originY);
        this.program.setUniformf(U_ZOOM, this.zoom);
        this.program.end();
    }

    public void render(VfxRenderContext context, VfxPingPongWrapper buffers) {
        this.render(context, buffers.getSrcBuffer(), buffers.getDstBuffer());
    }

    public void render(VfxRenderContext context, VfxFrameBuffer src, VfxFrameBuffer dst) {
        src.getTexture().bind(0);
        this.renderShader(context, dst);
    }

    public float getOriginX() {
        return this.originX;
    }

    public float getOriginY() {
        return this.originY;
    }

    public void setOrigin(int align) {
        float originX = (align & 8) != 0 ? 0.0f : ((align & 0x10) != 0 ? 1.0f : 0.5f);
        float originY = (align & 4) != 0 ? 0.0f : ((align & 2) != 0 ? 1.0f : 0.5f);
        this.setOrigin(originX, originY);
    }

    public void setOrigin(float originX, float originY) {
        this.originX = originX;
        this.originY = originY;
        this.program.begin();
        this.program.setUniformf(U_OFFSET_X, originX);
        this.program.setUniformf(U_OFFSET_Y, originY);
        this.program.end();
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
        this.setUniform(U_ZOOM, zoom);
    }
}

